package org.lsst.ccs.subsystem.common.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.data.MonitorTask;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

/**
 *  Implements the monitor task line sub-panel.
 *
 *  This needs to be incorporated into a "top-level" panel
 *
 *  @author Owen Saxton
 */
public class MonitorTaskLine extends JPanel implements UiUtilities.ActionHandler {

    private static final int horzInset = UiUtilities.getLabelSize("M").width / 2;

    private final CommandSender sender;
    private final String node;
    private final UiUtilities uiUtils;
    private JLabel taskNameLabel;
    private TextFieldX periodTextField;
    private JCheckBox periodCheckbox;

    public MonitorTaskLine(CommandSender sender, String node, int nameSize) {
        this.sender = sender;
        this.node = node;
        uiUtils = new UiUtilities(this);
        initComponents(nameSize);
        disablePanel();
    }

    public void updatePanel(MonitorTask task) {
        taskNameLabel.setEnabled(true);
        taskNameLabel.setText(task.getName());
        periodTextField.update(task.getPeriod() / 1000.0, true);
        periodCheckbox.setEnabled(true);
        periodCheckbox.setSelected(task.isActive());
    }

    public void disablePanel() {
        taskNameLabel.setEnabled(false);
        periodTextField.setDisabled();
        periodCheckbox.setEnabled(false);
    }

    private void initComponents(int nameSize) {
        taskNameLabel = UiUtilities.newLabel("XXX", nameSize);
        periodTextField = uiUtils.newTextFieldX("99999.9", "", TextFieldX.TYPE_DOUBLE, true);
        periodCheckbox = uiUtils.newCheckBox("", "");

        setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(0, horzInset, -3, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = GridBagConstraints.WEST;
        add(UiUtilities.newLabel("Task:  ", 0), gbh);
        gbh.gridx++;
        gbh.insets.left = 0;
        add(taskNameLabel, gbh);
        gbh.gridx++;
        gbh.insets.left = 25;
        add(UiUtilities.newLabel("Period:  ", 0), gbh);
        gbh.gridx++;
        gbh.insets.left = 0;
        gbh.insets.top -= 2;
        add(periodTextField, gbh);
        gbh.gridx++;
        gbh.insets.left = horzInset;
        gbh.insets.top += 2;
        add(UiUtilities.newLabel("sec", 0), gbh);
        gbh.gridx++;
        gbh.insets.left = 25;
        add(UiUtilities.newLabel("Active: ", 0), gbh);
        gbh.gridx++;
        gbh.insets.left = 0;
        add(periodCheckbox, gbh);
    }

    @Override
    public void handleTextFieldX(String name, Object value) {
        sender.sendCommand(node, "setTaskPeriod", taskNameLabel.getText(), (int)(1000 * (Double)value));
    }

    @Override
    public void handleCheckBox(String name, boolean selected) {
        sender.sendCommand(node, "setTaskActive", taskNameLabel.getText(), selected);
    }

    private static final long serialVersionUID = 1L;
}
