/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.IAnnotation;
import hep.aida.IFitData;
import hep.aida.IFunction;
import hep.aida.dev.IDevFitData;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ext.IFitMethod;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import java.util.ArrayList;

public class InternalObjectiveFunction
implements IFunction {
    private ArrayList vars = new ArrayList();
    private Function[] functions;
    private IDevFitDataIterator[] iters;
    private IFitMethod fitMethod;

    public InternalObjectiveFunction(IFitData[] data, Function[] functions, IFitMethod fitMethod) {
        this.functions = functions;
        this.iters = new IDevFitDataIterator[data.length];
        this.fitMethod = fitMethod;
        for (int i = 0; i < functions.length; ++i) {
            this.iters[i] = ((IDevFitData)data[i]).dataIterator();
            Function f = functions[i];
            for (int j = 0; j < f.numberOfParameters(); ++j) {
                Parameter p = f.getParameter(j);
                if (this.vars.contains(p)) continue;
                this.vars.add(p);
            }
        }
    }

    public String normalizationParameter() {
        throw new UnsupportedOperationException();
    }

    public Parameter getVariable(int index) {
        return (Parameter)this.vars.get(index);
    }

    public double value(double[] values) {
        int i;
        double value = 0.0;
        for (i = 0; i < this.vars.size(); ++i) {
            ((Parameter)this.vars.get(i)).setValue(values[i]);
        }
        for (i = 0; i < this.functions.length; ++i) {
            Function f = this.functions[i];
            value += this.fitMethod.evaluate(this.iters[i], (IFunction)f);
        }
        return value;
    }

    public boolean providesGradient() {
        for (int i = 0; i < this.functions.length; ++i) {
            Function f = this.functions[i];
            for (int j = 0; j < f.numberOfParameters(); ++j) {
                if (f.providesGradientWithRespectToVariable(f.getParameter(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int dimension() {
        return this.vars.size();
    }

    public double[] gradient(double[] values) {
        int i;
        double[] grad = new double[this.vars.size()];
        for (i = 0; i < this.vars.size(); ++i) {
            ((Parameter)this.vars.get(i)).setValue(values[i]);
        }
        for (i = 0; i < this.functions.length; ++i) {
            Function f = this.functions[i];
            int fPars = f.numberOfParameters();
            double[] g = this.fitMethod.evaluateGradient(fPars, this.iters[i], (IFunction)f);
            for (int j = 0; j < fPars; ++j) {
                Parameter p = f.getParameter(j);
                int n = this.vars.indexOf(p);
                grad[n] = grad[n] + g[j];
            }
        }
        return grad;
    }

    public int numberOfParameters() {
        return 0;
    }

    public String variableName(int index) {
        return ((Parameter)this.vars.get(index)).name();
    }

    public String[] variableNames() {
        String[] names = new String[this.vars.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((Parameter)this.vars.get(i)).name();
        }
        return names;
    }

    public IAnnotation annotation() {
        throw new UnsupportedOperationException();
    }

    public String codeletString() {
        throw new UnsupportedOperationException();
    }

    public int indexOfParameter(String str) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqual(IFunction iFunction) {
        throw new UnsupportedOperationException();
    }

    public double parameter(String str) {
        throw new UnsupportedOperationException();
    }

    public String[] parameterNames() {
        throw new UnsupportedOperationException();
    }

    public double[] parameters() {
        throw new UnsupportedOperationException();
    }

    public void setParameter(String str, double param) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void setParameters(double[] values) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void setTitle(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public String title() {
        throw new UnsupportedOperationException();
    }
}

