/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.ftdi.FtdiClient;
import org.lsst.ccs.drivers.ftdi.FtdiInterface;
import org.lsst.ccs.drivers.ftdi.FtdiLocal;

public class Ftdi
implements FtdiInterface {
    public static final int DATABITS_8 = 8;
    public static final int DATABITS_7 = 7;
    public static final int STOPBITS_1 = 0;
    public static final int STOPBITS_2 = 2;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int MODEM_STATUS_CTS = 16;
    public static final int MODEM_STATUS_DSR = 32;
    public static final int MODEM_STATUS_RI = 64;
    public static final int MODEM_STATUS_DCD = 128;
    public static final int FLOW_CONTROL_NONE = 0;
    public static final int FLOW_CONTROL_RTS_CTS = 256;
    public static final int FLOW_CONTROL_DTR_DSR = 512;
    public static final int FLOW_CONTROL_XON_XOFF = 1024;
    public static final int EVENT_RXCHAR = 1;
    public static final int EVENT_MODEM_STATUS = 2;
    public static final int EVENT_LINE_STATUS = 4;
    private FtdiClient client;
    private FtdiLocal local;
    private FtdiInterface ftdi;

    @Override
    public void open(int index, String serial) throws DriverException {
        this.checkNotOpen();
        if (this.local == null) {
            this.local = new FtdiLocal();
        }
        this.local.open(index, serial);
        this.ftdi = this.local;
    }

    @Override
    public void open(String node, int index, String serial) throws DriverException {
        if (node == null) {
            this.open(index, serial);
        } else {
            this.checkNotOpen();
            if (this.client == null) {
                this.client = new FtdiClient();
            }
            this.client.open(node, index, serial);
            this.ftdi = this.client;
        }
    }

    @Override
    public void close() throws DriverException {
        this.checkOpen();
        try {
            this.ftdi.close();
        }
        finally {
            this.ftdi = null;
        }
    }

    @Override
    public void setBaudrate(int baudrate) throws DriverException {
        this.checkOpen();
        this.ftdi.setBaudrate(baudrate);
    }

    @Override
    public void setDataCharacteristics(int wordLength, int stopBits, int parity) throws DriverException {
        this.checkOpen();
        this.ftdi.setDataCharacteristics(wordLength, stopBits, parity);
    }

    @Override
    public void setFlowControl(int flow) throws DriverException {
        this.checkOpen();
        this.ftdi.setFlowControl(flow);
    }

    @Override
    public void setTimeouts(int rcveTimeout, int xmitTimeout) throws DriverException {
        this.checkOpen();
        this.ftdi.setTimeouts(rcveTimeout, xmitTimeout);
    }

    @Override
    public void setDtr(boolean set) throws DriverException {
        this.checkOpen();
        this.ftdi.setDtr(set);
    }

    @Override
    public void setRts(boolean set) throws DriverException {
        this.checkOpen();
        this.ftdi.setRts(set);
    }

    @Override
    public void enableEvents(int mask) throws DriverException {
        this.checkOpen();
        this.ftdi.enableEvents(mask);
    }

    @Override
    public int awaitEvent(int timeout) throws DriverException {
        this.checkOpen();
        return this.ftdi.awaitEvent(timeout);
    }

    @Override
    public int read(byte[] data) throws DriverException {
        this.checkOpen();
        return this.ftdi.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int count) throws DriverException {
        this.checkOpen();
        return this.ftdi.read(data, offset, count);
    }

    @Override
    public int write(byte[] data) throws DriverException {
        this.checkOpen();
        return this.ftdi.write(data, 0, data.length);
    }

    @Override
    public int write(byte[] data, int offset, int count) throws DriverException {
        this.checkOpen();
        return this.ftdi.write(data, offset, count);
    }

    @Override
    public int getQueueStatus() throws DriverException {
        this.checkOpen();
        return this.ftdi.getQueueStatus();
    }

    @Override
    public int getModemStatus() throws DriverException {
        this.checkOpen();
        return this.ftdi.getModemStatus();
    }

    private void checkNotOpen() throws DriverException {
        if (this.ftdi != null) {
            throw new DriverException("Device already open");
        }
    }

    private void checkOpen() throws DriverException {
        if (this.ftdi == null) {
            throw new DriverException("Device not open");
        }
    }
}

