package org.lsst.ccs.subsystem.common.ui.focalplane.view;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;

/**
 * Specialized {@code MonitorView} for displaying data indexed by focal plane geometry.
 *
 * @author onoprien
 */
public interface FocalPlaneView extends PersistableMonitorView {

// -- Fields : -----------------------------------------------------------------

    static public final String CATEGORY = "FocalPlaneView";


// -- Override GroupView : -----------------------------------------------------

    @Override
    FocalPlaneFilter getFilter();
    
    default String getGroup(String displayPath) {
        return Segment.stripPathPrefix(displayPath);
    }

    default List<String> getGroups() {
        FocalPlaneFilter f = getFilter();
        if (f == null) return null;
        return f.getGroups();
    }


// -- Descriptor : -------------------------------------------------------------
    
    static public class Descriptor extends AbstractMonitorView.Descriptor {
        public Descriptor() {
            setCategory(CATEGORY);
        }
    }

}
