/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class SubsystemSelectorFilter
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Basic/Subsystem Selector";
    private final String agent;
    private final int index;

    @Create(category="AgentChannelsFilter", name="Subsystem Selector", path="Built-In/Basic/Subsystem Selector", description="Selects channels from the specified subsystem only. Strips the subsystem name, but leaves the channel path otherwise unchanged.")
    public SubsystemSelectorFilter(@Par(desc="Subsystem name.") String subsystem) {
        this.agent = subsystem;
        this.index = subsystem.length() + 1;
    }

    @Override
    public List<String> getAgents() {
        return Collections.singletonList(this.agent);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return this.agent + "/" + displayPath;
    }

    @Override
    public String getDisplayPath(String originPath) {
        return originPath.substring(this.index);
    }

    @Override
    public String getName() {
        return this.agent;
    }
}

