/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.studio.EventSender;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.event.EditorPopupEvent;
import org.freehep.jas.extension.editor.FontPropertyDialog;
import org.freehep.jas.plugin.xmlio.XMLPluginIO;
import org.freehep.jas.services.FileHandler;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.jas.services.TextEditor;
import org.freehep.jas.services.TextEditorService;
import org.freehep.swing.ExtensionFileFilter;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.images.ImageHandler;
import org.freehep.xml.io.XMLIOManager;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.jdom.Content;
import org.jdom.Element;
import org.xml.sax.SAXException;

public class SimpleEditor
extends Plugin
implements TextEditorService,
FileHandler,
XMLPluginIO,
PreferencesTopic,
WindowFocusListener {
    private static Icon defIcon = ImageHandler.getIcon((String)"/toolbarButtonGraphics/general/Edit16.gif", SimpleEditor.class);
    private GlobalCommands global = new GlobalCommands();
    private Map mimeTypes = new HashMap();
    private boolean listenerInstalled = false;
    private Properties userProperties;
    private static String[] textFields = new String[]{"Code", "Line Number"};
    private static String[] defaultColor = new String[]{"-16777216", "-8372160"};
    private static String[] defaultSize = new String[]{"12", "10"};
    private static String[] defaultType = new String[]{"Dialog", "Dialog"};
    private static String[] defaultStyle = new String[]{"Plain", "Italic"};
    private static String pageType = "Editor";

    public TextEditor getCurrentEditor() {
        PageContext context = this.getApplication().getPageManager().getSelectedPage();
        if (context != null) {
            Component c = context.getPage();
            if (c instanceof JScrollPane) {
                c = ((JScrollPane)c).getViewport().getView();
            }
            if (c instanceof TextEditor) {
                return (TextEditor)c;
            }
        }
        return null;
    }

    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("txt", "Text File");
    }

    public Icon getIconForMimeType(String mimeType) {
        return (Icon)this.mimeTypes.get(mimeType);
    }

    public boolean accept(File file) throws IOException {
        return file.getName().endsWith(".txt");
    }

    public void addMimeType(String mimeType, Icon icon) {
        this.mimeTypes.put(mimeType, icon);
    }

    public List editors() {
        ArrayList<Component> l = new ArrayList<Component>();
        List pages = this.getApplication().getPageManager().pages();
        for (PageContext context : pages) {
            Component c = context.getPage();
            if (c instanceof JScrollPane) {
                c = ((JScrollPane)c).getViewport().getView();
            }
            if (!(c instanceof TextEditor)) continue;
            l.add(c);
        }
        return l;
    }

    public void openFile(File file) throws IOException {
        this.show(file, "text/plain");
    }

    private File getLastDir() {
        String file = this.userProperties.getProperty("editor.lastDir", "{user.home}");
        return new File(file);
    }

    private void setLastDir(File dir) {
        this.userProperties.setProperty("editor.lastDir", dir.getAbsolutePath());
    }

    public int restore(int level, XMLIOManager manager, Element el) {
        switch (level) {
            case 0: {
                try {
                    List editAreas = el.getChildren("editArea");
                    for (int i = 0; i < editAreas.size(); ++i) {
                        Element editAreaEl = (Element)editAreas.get(i);
                        String fileName = editAreaEl.getAttributeValue("file");
                        String mimeType = editAreaEl.getAttributeValue("mime");
                        if (fileName != null) {
                            File file = new File(fileName);
                            this.show(file, mimeType);
                            continue;
                        }
                        Element urlEl = editAreaEl.getChild("URL");
                        String host = urlEl.getAttributeValue("host");
                        String protocol = urlEl.getAttributeValue("protocol");
                        String file = urlEl.getAttributeValue("file");
                        URL url = new URL(protocol, host, file);
                        this.show(url, mimeType);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage());
                }
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal level " + level + ". Please report this problem");
    }

    public void save(XMLIOManager manager, Element el) {
        for (EditArea editArea : this.editors()) {
            URL url;
            Element fileEl = new Element("editArea");
            File file = editArea.getFile();
            if (file != null) {
                fileEl.setAttribute("file", file.getAbsolutePath());
            }
            if ((url = editArea.getURL()) != null) {
                Element urlEl = new Element("URL");
                urlEl.setAttribute("file", url.getFile());
                urlEl.setAttribute("protocol", url.getProtocol());
                urlEl.setAttribute("host", url.getHost());
                fileEl.addContent((Content)urlEl);
            }
            if (url == null && file == null) continue;
            fileEl.setAttribute("mime", editArea.getMimeType());
            el.addContent((Content)fileEl);
        }
    }

    private String makeType(String mimeType) {
        String tmpType = mimeType.substring(mimeType.indexOf("/") + 1);
        tmpType = tmpType.toUpperCase().substring(0, 1) + tmpType.toLowerCase().substring(1);
        return tmpType + " " + pageType;
    }

    public void show(String text, String mimeType, String title) {
        if (title == null) {
            title = "Untitled";
        }
        this.getApplication().getPageManager().openPage((Component)new JScrollPane(new EditArea(this.getApplication(), mimeType, text)), title, this.getIconForMimeType(mimeType), this.makeType(mimeType));
    }

    public void show(File file, String mimeType) throws IOException {
        EditArea text = new EditArea(this.getApplication(), mimeType, file);
        this.getApplication().getPageManager().openPage((Component)new JScrollPane(text), file.getName(), this.getIconForMimeType(mimeType), this.makeType(mimeType));
    }

    public void show(URL url, String mimeType) throws IOException {
        String title = url.getFile();
        int pos = title.lastIndexOf("/");
        if (pos > 0) {
            title = title.substring(pos + 1);
        }
        EditArea text = new EditArea(this.getApplication(), mimeType, url);
        this.getApplication().getPageManager().openPage((Component)new JScrollPane(text), title, this.getIconForMimeType(mimeType), this.makeType(mimeType));
    }

    public void show(Reader reader, String mimeType, String title) throws IOException {
        EditArea text = new EditArea(this.getApplication(), mimeType, reader);
        if (title == null) {
            title = "Untitled";
        }
        this.getApplication().getPageManager().openPage((Component)new JScrollPane(text), title, this.getIconForMimeType(mimeType), this.makeType(mimeType));
    }

    protected void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        app.getLookup().add((Object)this);
        XMLMenuBuilder builder = app.getXMLMenuBuilder();
        URL xml = this.getClass().getResource("SimpleEditor.menus");
        builder.build(xml);
        app.getCommandTargetManager().add((CommandGroup)this.global);
        app.addToolBar(builder.getToolBar("editToolBar"), "Edit Toolbar");
        app.addToolBar(builder.getToolBar("fileToolBar"), "File Toolbar");
        this.userProperties = app.getUserProperties();
    }

    private void show(String text, String mimeType, String title, Icon icon) {
        this.getApplication().getPageManager().openPage((Component)new JScrollPane(new EditArea(this.getApplication(), mimeType, text)), title, icon, this.makeType(mimeType));
    }

    public boolean apply(JComponent panel) {
        ((FontPropertyDialog)panel).apply();
        for (EditArea editArea : this.editors()) {
            editArea.setFontAndColor(this.getFont(textFields[0]), this.getFontColor(textFields[0]));
            LineNumberBorder lnb = (LineNumberBorder)editArea.getBorder();
            lnb.setFontAndColor(this.getFont(textFields[1]), this.getFontColor(textFields[1]));
        }
        return true;
    }

    public JComponent component() {
        return new FontPropertyDialog(this, textFields);
    }

    public String[] path() {
        return new String[]{"SimpleEditor"};
    }

    void setFontSize(String text, String fontSize) {
        this.userProperties.setProperty(text + "FontSize", fontSize);
    }

    void setFontType(String text, String fontType) {
        this.userProperties.setProperty(text + "FontType", fontType);
    }

    void setFontStyle(String text, String fontStyle) {
        this.userProperties.setProperty(text + "FontStyle", fontStyle);
    }

    void setColor(String text, Color color) {
        String colorSt = String.valueOf(color.getRGB());
        this.userProperties.setProperty(text + "FontColor", colorSt);
    }

    String getFontType(String text) {
        return PropertyUtilities.getString((Properties)this.userProperties, (String)(text + "FontType"), (String)defaultType[this.textFieldIndex(text)]);
    }

    String getFontSize(String text) {
        return PropertyUtilities.getString((Properties)this.userProperties, (String)(text + "FontSize"), (String)defaultSize[this.textFieldIndex(text)]);
    }

    String getFontStyle(String text) {
        return PropertyUtilities.getString((Properties)this.userProperties, (String)(text + "FontStyle"), (String)defaultStyle[this.textFieldIndex(text)]);
    }

    Color getFontColor(String text) {
        String colorSt = PropertyUtilities.getString((Properties)this.userProperties, (String)(text + "FontColor"), (String)defaultColor[this.textFieldIndex(text)]);
        return new Color(Integer.valueOf(colorSt));
    }

    boolean isCheckForFileChanges() {
        return PropertyUtilities.getBoolean((Properties)this.userProperties, (String)"checkForFileChanges", (boolean)true);
    }

    void setCheckForFileChanges(boolean value) {
        PropertyUtilities.setBoolean((Properties)this.userProperties, (String)"checkForFileChanged", (boolean)value);
    }

    private Font getFont(String textField) {
        String fontType = this.getFontType(textField);
        int fontSize = Integer.valueOf(this.getFontSize(textField));
        Font font = new Font(fontType, 0, fontSize);
        String fontStyle = this.getFontStyle(textField);
        if (fontStyle.indexOf("Bold") != -1) {
            font = font.deriveFont(1);
        }
        if (fontStyle.indexOf("Italic") != -1) {
            font = font.deriveFont(2);
        }
        return font;
    }

    private int textFieldIndex(String textField) {
        for (int i = 0; i < textFields.length; ++i) {
            if (!textField.equals(textFields[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid text field " + textField);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        TextEditor te = this.getCurrentEditor();
        if (te instanceof EditArea) {
            ((EditArea)te).checkForFileChanged();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    private final class LineNumberBorder
    implements Border {
        private Color background = new Color(224, 224, 224);
        private Color foreground;
        private Font font;
        private Insets insets = new Insets(0, 0, 0, 0);
        private JTextArea textArea;
        private int extraPad = 2;
        private int leftPad = 2;
        private int rightPad = 2;

        LineNumberBorder(JTextArea area) {
            this.textArea = area;
            this.setFontAndColor(SimpleEditor.this.getFont(textFields[1]), SimpleEditor.this.getFontColor(textFields[1]));
        }

        protected void setFontAndColor(Font font, Color color) {
            this.font = font;
            this.foreground = color;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            FontMetrics fm = this.textArea.getFontMetrics(this.font);
            int nRows = this.textArea.getLineCount();
            int l = String.valueOf(nRows).length();
            this.insets.left = l * fm.charWidth('9') + this.leftPad + this.rightPad + this.extraPad;
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.background);
            g.fillRect(x, y, this.insets.left - this.extraPad, height);
            g.setColor(this.foreground);
            g.setFont(this.font);
            FontMetrics tafm = this.textArea.getFontMetrics(this.textArea.getFont());
            int lineHeight = tafm.getHeight();
            int textAreaHeight = this.textArea.getHeight();
            Rectangle clip = g.getClipBounds();
            int firstRow = 1 + (clip.y - y) / lineHeight;
            int lastRow = 2 + (clip.y + clip.height - y) / lineHeight;
            lastRow = Math.min(lastRow, this.textArea.getLineCount());
            int yPos = y + firstRow * lineHeight - tafm.getDescent();
            int xPos = x + this.insets.left - this.rightPad - this.extraPad;
            FontMetrics fm = this.textArea.getFontMetrics(this.font);
            for (int i = firstRow; i <= lastRow; ++i) {
                String number = String.valueOf(i);
                int lineWidth = fm.stringWidth(number);
                g.drawString(number, xPos - lineWidth, yPos);
                yPos += lineHeight;
            }
        }
    }

    private class EditArea
    extends JTextArea
    implements HasPopupItems,
    ManagedPage,
    TextEditor,
    Scrollable {
        private Commands commands = new Commands();
        private File file;
        private long timestamp;
        private URL url;
        private PageContext pageContext;
        private String mimeType;
        private Studio app;
        private boolean modified = false;

        EditArea(Studio app, String mimeType) {
            this.init(app, mimeType);
        }

        EditArea(Studio app, String mimeType, String text) {
            this.setText(text);
            this.init(app, mimeType);
        }

        EditArea(Studio app, String mimeType, File file) throws IOException {
            this(app, mimeType, new FileReader(file), file);
            this.file = file;
            this.timestamp = file.lastModified();
        }

        EditArea(Studio app, String mimeType, URL url) throws IOException {
            this(app, mimeType, new InputStreamReader(url.openStream()));
            this.url = url;
        }

        EditArea(Studio app, String mimeType, Reader reader) throws IOException {
            this(app, mimeType, reader, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EditArea(Studio app, String mimeType, Reader reader, Object desc) throws IOException {
            try {
                this.read(reader, desc);
            }
            finally {
                reader.close();
            }
            this.init(app, mimeType);
        }

        public File getFile() {
            return this.file;
        }

        public URL getURL() {
            return this.url;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public boolean isModified() {
            return this.modified;
        }

        public void setPageContext(PageContext context) {
            this.pageContext = context;
        }

        public String getTitle() {
            return this.pageContext.getTitle();
        }

        public boolean close() {
            boolean close = true;
            if (this.modified) {
                int rc = JOptionPane.showConfirmDialog((Component)this.app, "Save Changes?");
                close = rc == 0 ? this.save(this.file) : rc == 1;
            }
            return close;
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
            this.app.getXMLMenuBuilder().mergePopupMenu("editPopupMenu", menu);
            EventSender es = this.app.getEventSender();
            if (es.hasListeners(EditorPopupEvent.class)) {
                EditorPopupEvent e = new EditorPopupEvent((TextEditor)this, menu);
                es.broadcast((EventObject)e);
            }
            return menu;
        }

        public void pageClosed() {
        }

        public void pageDeiconized() {
        }

        public void pageDeselected() {
            this.app.getCommandTargetManager().remove((CommandGroup)this.commands);
        }

        public void pageIconized() {
        }

        public void pageSelected() {
            this.app.getCommandTargetManager().add((CommandGroup)this.commands);
            this.checkForFileChanged();
        }

        private void checkForFileChanged() {
            long curr;
            if (this.file != null && SimpleEditor.this.isCheckForFileChanges() && this.timestamp != (curr = this.file.lastModified())) {
                int type;
                int rc;
                this.timestamp = curr;
                String message = "File " + this.file.getName() + " modified on disk, reload?";
                if (this.modified) {
                    message = message + "\nWarning: Answering yes will discard local changes";
                }
                if ((rc = JOptionPane.showConfirmDialog((Component)this.app, message, "Reload?", 0, type = this.modified ? 2 : 3)) == 0) {
                    this.reload();
                }
            }
        }

        private void init(Studio app, String mimeType) {
            this.app = app;
            this.mimeType = mimeType;
            this.setBorder(new LineNumberBorder(this));
            this.addCaretListener(this.commands);
            this.getDocument().addUndoableEditListener(this.commands);
            this.setFontAndColor(SimpleEditor.this.getFont(textFields[0]), SimpleEditor.this.getFontColor(textFields[0]));
        }

        protected void setFontAndColor(Font font, Color color) {
            this.setFont(font);
            this.setForeground(color);
        }

        private void reload() {
            try {
                super.read(new FileReader(this.file), this.file);
                this.getDocument().addUndoableEditListener(this.commands);
                this.timestamp = this.file.lastModified();
                this.modified = false;
                this.commands.clearEdits();
                this.commands.setChanged();
                SimpleEditor.this.global.setChanged();
            }
            catch (IOException x) {
                this.app.error("Couldn't reload file" + this.file.getName(), (Throwable)x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean save(File f) {
            boolean bl;
            if (f == null) {
                int rc;
                JFileChooser chooser = new JFileChooser(SimpleEditor.this.getLastDir());
                if (this.file != null) {
                    chooser.setSelectedFile(this.file);
                }
                chooser.setDialogTitle("Save As...");
                int returnVal = chooser.showSaveDialog((Component)this.app);
                if (returnVal != 0) {
                    return false;
                }
                f = chooser.getSelectedFile();
                if (f.exists() && (rc = JOptionPane.showConfirmDialog((Component)this.app, "Replace existing file?", null, 2)) != 0) {
                    return false;
                }
            }
            FileWriter out = new FileWriter(f);
            try {
                this.write(out);
                if (f != this.file) {
                    this.file = f;
                    SimpleEditor.this.setLastDir(f.getParentFile());
                    this.pageContext.setTitle(f.getName());
                }
                this.modified = false;
                this.commands.setChanged();
                SimpleEditor.this.global.setChanged();
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)out).close();
                    this.timestamp = f.lastModified();
                    throw throwable;
                }
                catch (IOException eh) {
                    this.app.error("Couldn't save to file" + f.getName(), (Throwable)eh);
                    return false;
                }
            }
            ((Writer)out).close();
            this.timestamp = f.lastModified();
            return bl;
        }

        public void saveText() {
            this.save(this.file);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!SimpleEditor.this.listenerInstalled) {
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)SimpleEditor.this.getApplication());
                window.addWindowFocusListener(SimpleEditor.this);
                SimpleEditor.this.listenerInstalled = true;
            }
        }

        class Commands
        extends CommandProcessor
        implements UndoableEditListener,
        CaretListener {
            private UndoManager um = new UndoManager();

            Commands() {
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                this.setChanged();
            }

            public void enableCopy(CommandState state) {
                state.setEnabled(EditArea.this.getSelectedText() != null);
            }

            public void enableCut(CommandState state) {
                state.setEnabled(EditArea.this.getSelectedText() != null);
            }

            public void enableRedo(CommandState state) {
                state.setEnabled(this.um.canRedo());
            }

            public void enableSave(CommandState state) {
                state.setEnabled(EditArea.this.modified);
            }

            public void enableRefresh(CommandState state) {
                state.setEnabled(EditArea.this.file != null);
            }

            public void enableUndo(CommandState state) {
                state.setEnabled(this.um.canUndo());
            }

            public void onCopy() {
                EditArea.this.copy();
            }

            public void onCut() {
                EditArea.this.cut();
            }

            public void onPaste() {
                EditArea.this.paste();
            }

            public void onRedo() {
                this.um.redo();
                EditArea.this.modified = true;
                this.setChanged();
                SimpleEditor.this.global.setChanged();
            }

            public void onSave() {
                EditArea.this.save(EditArea.this.file);
            }

            public void onSaveAs() {
                EditArea.this.save(null);
            }

            public void onUndo() {
                this.um.undo();
                EditArea.this.modified = true;
                this.setChanged();
                SimpleEditor.this.global.setChanged();
            }

            public void onRefresh() {
                int rc;
                if (EditArea.this.modified && (rc = JOptionPane.showConfirmDialog((Component)EditArea.this.app, "Discard changes?", "Discard?", 0, 2)) != 0) {
                    return;
                }
                EditArea.this.reload();
            }

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                this.um.addEdit(e.getEdit());
                EditArea.this.modified = true;
                this.setChanged();
                SimpleEditor.this.global.setChanged();
            }

            void clearEdits() {
                this.um.discardAllEdits();
            }
        }
    }

    class GlobalCommands
    extends CommandProcessor {
        GlobalCommands() {
        }

        public void enableSaveAll(CommandState state) {
            boolean canSaveAll = false;
            List list = SimpleEditor.this.getApplication().getPageManager().pages();
            for (PageContext context : list) {
                EditArea edit;
                Component c = context.getPage();
                if (c instanceof JScrollPane) {
                    c = ((JScrollPane)c).getViewport().getView();
                }
                if (!(c instanceof EditArea) || !(edit = (EditArea)c).isModified()) continue;
                canSaveAll = true;
                break;
            }
            state.setEnabled(canSaveAll);
        }

        public void onSaveAll() {
            List list = SimpleEditor.this.getApplication().getPageManager().pages();
            for (PageContext context : list) {
                EditArea edit;
                Component c = context.getPage();
                if (c instanceof JScrollPane) {
                    c = ((JScrollPane)c).getViewport().getView();
                }
                if (!(c instanceof EditArea) || !(edit = (EditArea)c).isModified()) continue;
                edit.save(null);
            }
        }
    }
}

