/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.Component;
import java.awt.Dimension;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.DatePicker;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;

public class JTimeDateChooser
extends JPanel {
    private final int VSPACE = 5;
    private final int HSPACE = 10;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private boolean armed = true;
    private boolean armedFX = true;
    private final JFXPanel fxPanel;
    private DatePicker datePicker;
    private LocalDate date;
    private ZoneId zone = ZoneId.systemDefault();
    private final JSpinner timeSpinner;
    private final SpinnerDateModel timeModel;

    static JTimeDateChooser getInstance() {
        return JTimeDateChooser.getInstance(null);
    }

    static JTimeDateChooser getInstance(ZonedDateTime time) {
        Platform.setImplicitExit((boolean)false);
        JTimeDateChooser instance = new JTimeDateChooser();
        instance.init();
        if (time != null) {
            instance.set(time);
        }
        return instance;
    }

    private JTimeDateChooser() {
        this.setLayout(new BoxLayout(this, 0));
        this.fxPanel = new JFXPanel();
        this.add((Component)this.fxPanel);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.timeModel = new SpinnerDateModel(new Date(0L), new Date(0L), new Date(0x3FFFFFFFFFFFFFFFL), 10);
        this.timeSpinner = new JSpinner(this.timeModel);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.timeSpinner, "HH:mm:ss");
        this.timeSpinner.setEditor(editor);
        this.timeSpinner.addChangeListener(e -> this.fire());
        this.add(this.timeSpinner);
        this.add(Box.createHorizontalGlue());
    }

    private void init() {
        Platform.runLater(() -> {
            this.datePicker = new DatePicker();
            this.datePicker.setOnAction(e -> {
                if (this.armedFX) {
                    this.date = (LocalDate)this.datePicker.getValue();
                    SwingUtilities.invokeLater(this::fire);
                }
            });
            Scene scene = new Scene((Parent)this.datePicker, (Paint)Color.ALICEBLUE);
            this.fxPanel.setScene(scene);
        });
    }

    public Instant get() {
        ZonedDateTime time = this.timeModel.getDate().toInstant().atZone(ZoneId.systemDefault());
        LocalTime localTime = time.toLocalTime();
        LocalDateTime localDateTime = localTime.atDate(this.date);
        return localDateTime.atZone(this.zone).toInstant();
    }

    public void set(Instant instant) {
        ZonedDateTime dt = instant.atZone(this.zone);
        this.armed = false;
        this.timeModel.setValue(new Date(instant.toEpochMilli()));
        this.date = dt.toLocalDate();
        Platform.runLater(() -> {
            this.armedFX = false;
            this.datePicker.setValue((Object)this.date);
            this.armedFX = true;
        });
        this.armed = true;
    }

    public void set(ZonedDateTime time) {
        this.set(time.toInstant());
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public void set(Date date) {
        this.set(Instant.ofEpochMilli(date.getTime()));
    }

    public void setZone(ZoneId zone) {
        Instant dt = this.get();
        this.zone = zone;
        this.set(dt);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Platform.runLater(() -> this.datePicker.setDisable(!enabled));
        this.timeSpinner.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void addListener(Listener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void fire() {
        if (this.armed) {
            this.listeners.forEach(listener -> listener.changed(this));
        }
    }

    public static interface Listener {
        public void changed(JTimeDateChooser var1);
    }
}

