/*
 * Decompiled with CFR 0.152.
 */
package jas.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PnutsLayout
implements LayoutManager2,
Serializable {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int V_FIT = 16;
    public static final int H_FIT = 32;
    static final int V_FILL = 3;
    static final int H_FILL = 12;
    static Integer[] integer;
    static int[] zero;
    Hashtable alignmentTable = new Hashtable();
    Hashtable spanTable = new Hashtable();
    Hashtable padTable = new Hashtable();
    Hashtable iPadTable = new Hashtable();
    private int[] widths;
    private int[] heights;
    private int[] hfit;
    private int[] vfit;
    private int hfits;
    private int vfits;
    int[] grid_x;
    int[] grid_y;
    int[] pos_x = new int[8];
    int[] pos_y = new int[8];
    private Dimension psize;
    private boolean valid = false;
    protected int align = 0;
    protected int padx;
    protected int pady;
    protected int ipadx;
    protected int ipady;
    protected int cols;
    protected int rows;
    protected boolean xfix;
    protected boolean yfix;

    static Integer getInteger(int i) {
        if (i < 32) {
            return integer[i];
        }
        return new Integer(i);
    }

    public PnutsLayout() {
        this(1);
    }

    public PnutsLayout(int cols) {
        this(cols, 0, 0);
    }

    public PnutsLayout(int cols, int padx, int pady) {
        this.cols = cols;
        this.padx = padx;
        this.pady = pady;
    }

    public PnutsLayout(String str) {
        Hashtable t = PnutsLayout.str2table(str);
        this.cols = PnutsLayout.getInt(t.get("cols"), 1);
        this.padx = PnutsLayout.getInt(t.get("padx"), 0);
        this.pady = PnutsLayout.getInt(t.get("pady"), 0);
        this.ipadx = PnutsLayout.getInt(t.get("ipadx"), 0);
        this.ipady = PnutsLayout.getInt(t.get("ipady"), 0);
        int ha = 0;
        int va = 0;
        String h = (String)t.get("halign");
        if (h != null) {
            if ("left".equalsIgnoreCase(h)) {
                ha |= 4;
            } else if ("right".equalsIgnoreCase(h)) {
                ha |= 8;
            } else if ("center".equalsIgnoreCase(h)) {
                ha |= 0;
            } else if ("fill".equalsIgnoreCase(h)) {
                ha |= 8;
                ha |= 4;
            }
        } else {
            ha = this.align & 0x2C;
        }
        String v = (String)t.get("valign");
        if (v != null) {
            if ("top".equalsIgnoreCase(v)) {
                va |= 1;
            } else if ("bottom".equalsIgnoreCase(v)) {
                va |= 2;
            } else if ("center".equalsIgnoreCase(v)) {
                va |= 0;
            } else if ("fill".equalsIgnoreCase(v)) {
                va |= 1;
                va |= 2;
            }
        } else {
            va = this.align & 0x13;
        }
        String ex = (String)t.get("expand");
        if (ex instanceof String) {
            if ("x".equalsIgnoreCase(ex)) {
                ha |= 0x20;
            } else if ("y".equalsIgnoreCase(ex)) {
                va |= 0x10;
            } else if ("xy".equalsIgnoreCase(ex)) {
                ha |= 0x20;
                va |= 0x10;
            }
        }
        this.align = ha | va;
        String fix = (String)t.get("uniform");
        if ("x".equals(fix)) {
            this.xfix = true;
        } else if ("y".equals(fix)) {
            this.yfix = true;
        } else if ("xy".equals(fix)) {
            this.xfix = true;
            this.yfix = true;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object obj) {
        if (obj instanceof Hashtable) {
            this.setConstraints(comp, (Hashtable)obj);
        } else if (obj instanceof String) {
            this.setConstraints(comp, (String)obj);
        }
    }

    public void setConstraints(Component comp, String str) {
        Object v2;
        Object v1;
        int hal = this.align & 0x2C;
        int val = this.align & 0x13;
        Hashtable tab = PnutsLayout.str2table(str);
        Object v0 = tab.get("expand");
        if (v0 instanceof String) {
            String s = (String)v0;
            if ("x".equalsIgnoreCase(s)) {
                hal |= 0x20;
            } else if ("y".equalsIgnoreCase(s)) {
                val |= 0x10;
            } else if ("xy".equalsIgnoreCase(s)) {
                hal |= 0x20;
                val |= 0x10;
            }
        }
        if ((v1 = tab.get("halign")) instanceof String) {
            hal &= 0xFFFFFFF3;
            String s = (String)v1;
            if ("left".equalsIgnoreCase(s)) {
                hal |= 4;
            } else if ("right".equalsIgnoreCase(s)) {
                hal |= 8;
            } else if ("center".equalsIgnoreCase(s)) {
                hal |= 0;
            } else if ("fill".equalsIgnoreCase(s)) {
                hal |= 8;
                hal |= 4;
            }
        }
        if ((v2 = tab.get("valign")) instanceof String) {
            val &= 0xFFFFFFFC;
            String s = (String)v2;
            if ("top".equalsIgnoreCase(s)) {
                val |= 1;
            } else if ("bottom".equalsIgnoreCase(s)) {
                val |= 2;
            } else if ("center".equalsIgnoreCase(s)) {
                val |= 0;
            } else if ("fill".equalsIgnoreCase(s)) {
                val |= 1;
                val |= 2;
            }
        }
        tab.put("valign", PnutsLayout.getInteger(val));
        tab.put("halign", PnutsLayout.getInteger(hal));
        this.setConstraints(comp, tab);
    }

    static int getInt(Object obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt((String)obj);
    }

    public void setConstraints(Component comp, Hashtable table) {
        int h = PnutsLayout.getInt(table.get("halign"), this.align & 0xC);
        int v = PnutsLayout.getInt(table.get("valign"), this.align & 3);
        this.alignmentTable.put(comp, PnutsLayout.getInteger(h | v));
        int c = PnutsLayout.getInt(table.get("colspan"), 1);
        if (c <= this.cols) {
            this.spanTable.put(comp, new Object[]{PnutsLayout.getInteger(c), PnutsLayout.getInteger(PnutsLayout.getInt(table.get("rowspan"), 1))});
        }
        this.padTable.put(comp, new Object[]{PnutsLayout.getInteger(PnutsLayout.getInt(table.get("padx"), this.padx)), PnutsLayout.getInteger(PnutsLayout.getInt(table.get("pady"), this.pady))});
        this.iPadTable.put(comp, new Object[]{PnutsLayout.getInteger(PnutsLayout.getInt(table.get("ipadx"), this.ipadx)), PnutsLayout.getInteger(PnutsLayout.getInt(table.get("ipady"), this.ipady))});
    }

    public String getConstraintString(Component comp) {
        int rowspan;
        int colspan;
        int ipady;
        int ipadx;
        int pady;
        int padx;
        String expand;
        String valign;
        Hashtable tab = this.getConstraints(comp);
        StringBuffer buf = new StringBuffer();
        String halign = (String)tab.get("halign");
        if (halign != null) {
            buf.append("halign = " + halign);
        }
        if ((valign = (String)tab.get("valign")) != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("valign = " + valign);
        }
        if ((expand = (String)tab.get("expand")) != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("expand = " + expand);
        }
        if ((padx = ((Integer)tab.get("padx")).intValue()) > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("padx = " + padx);
        }
        if ((pady = ((Integer)tab.get("pady")).intValue()) > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("pady = " + pady);
        }
        if ((ipadx = ((Integer)tab.get("ipadx")).intValue()) > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("ipadx = " + ipadx);
        }
        if ((ipady = ((Integer)tab.get("ipady")).intValue()) > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("ipady = " + ipady);
        }
        if ((colspan = ((Integer)tab.get("colspan")).intValue()) > 1) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("colspan = " + colspan);
        }
        if ((rowspan = ((Integer)tab.get("rowspan")).intValue()) > 1) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("rowspan = " + rowspan);
        }
        return buf.toString();
    }

    public Hashtable getConstraints(Component comp) {
        Object[] o4;
        Object[] o3;
        Object[] o2;
        Hashtable<String, Object> tab = new Hashtable<String, Object>();
        Object o1 = this.alignmentTable.get(comp);
        int align = this.align;
        if (o1 != null) {
            align = (Integer)o1;
            String halign = "center";
            String valign = "center";
            switch (align & 0xC) {
                case 4: {
                    halign = "left";
                    break;
                }
                case 8: {
                    halign = "right";
                    break;
                }
                case 12: {
                    halign = "fill";
                }
            }
            switch (align & 3) {
                case 1: {
                    valign = "top";
                    break;
                }
                case 2: {
                    valign = "bottom";
                    break;
                }
                case 3: {
                    valign = "fill";
                }
            }
            if (!"center".equals(halign)) {
                tab.put("halign", halign);
            }
            if (!"center".equals(valign)) {
                tab.put("valign", valign);
            }
            String expand = "";
            if ((align & 0x20) == 32) {
                expand = expand + "x";
            }
            if ((align & 0x10) == 16) {
                expand = expand + "y";
            }
            if (expand.length() > 0) {
                tab.put("expand", expand);
            }
        }
        if ((o2 = (Object[])this.padTable.get(comp)) != null) {
            tab.put("padx", o2[0]);
            tab.put("pady", o2[1]);
        }
        if ((o3 = (Object[])this.iPadTable.get(comp)) != null) {
            tab.put("ipadx", o3[0]);
            tab.put("ipady", o3[1]);
        }
        if ((o4 = (Object[])this.spanTable.get(comp)) != null) {
            tab.put("colspan", o4[0]);
            tab.put("rowspan", o4[1]);
        }
        return tab;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return target.getMaximumSize();
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.valid = false;
    }

    public void setCols(int cols) {
        Enumeration e = this.spanTable.elements();
        while (e.hasMoreElements()) {
            Object[] obj = (Object[])e.nextElement();
            int colspan = (Integer)obj[0];
            if (colspan <= cols) continue;
            return;
        }
        this.cols = cols;
        this.valid = false;
    }

    public void setUniform(boolean x, boolean y) {
        this.xfix = x;
        this.yfix = y;
        this.valid = false;
    }

    public boolean[] getUniform() {
        return new boolean[]{this.xfix, this.yfix};
    }

    public void setColspan(Component comp, int colspan) {
        Object[] p = (Object[])this.spanTable.get(comp);
        if (p != null) {
            p[0] = PnutsLayout.getInteger(colspan);
            this.spanTable.put(comp, p);
        } else {
            this.spanTable.put(comp, new Object[]{PnutsLayout.getInteger(colspan), PnutsLayout.getInteger(1)});
        }
        this.invalidateLayout(comp.getParent());
    }

    public int getColspan(Component comp) {
        Object[] o = (Object[])this.spanTable.get(comp);
        if (o == null || o.length < 2) {
            return 1;
        }
        return (Integer)o[0];
    }

    public void setRowspan(Component comp, int rowspan) {
        Object[] p = (Object[])this.spanTable.get(comp);
        if (p != null) {
            p[1] = PnutsLayout.getInteger(rowspan);
            this.spanTable.put(comp, p);
        } else {
            this.spanTable.put(comp, new Object[]{PnutsLayout.getInteger(1), PnutsLayout.getInteger(rowspan)});
        }
        this.invalidateLayout(comp.getParent());
    }

    public int getRowspan(Component comp) {
        Object[] o = (Object[])this.spanTable.get(comp);
        if (o == null || o.length < 2) {
            return 1;
        }
        return (Integer)o[1];
    }

    public void setHAlign(Component comp, String s) {
        int i = 0;
        i = "left".equalsIgnoreCase(s) ? 4 : ("right".equalsIgnoreCase(s) ? 8 : ("fill".equalsIgnoreCase(s) ? 12 : 0));
        this.alignmentTable.put(comp, PnutsLayout.getInteger(i));
        this.invalidateLayout(comp.getParent());
    }

    public void setVAlign(Component comp, String s) {
        int i = 0;
        i = "left".equalsIgnoreCase(s) ? 1 : ("bottom".equalsIgnoreCase(s) ? 2 : ("fill".equalsIgnoreCase(s) ? 3 : 0));
        this.alignmentTable.put(comp, PnutsLayout.getInteger(i));
        this.invalidateLayout(comp.getParent());
    }

    public String getHAlign(Component comp) {
        Integer it = (Integer)this.alignmentTable.get(comp);
        int i = this.align;
        if (it != null) {
            i = it;
        }
        if ((i & 0xC) == 12) {
            return "fill";
        }
        if ((i & 4) == 4) {
            return "left";
        }
        if ((i & 8) == 8) {
            return "right";
        }
        return "center";
    }

    public String getVAlign(Component comp) {
        Integer it = (Integer)this.alignmentTable.get(comp);
        int i = this.align;
        if (it != null) {
            i = it;
        }
        if ((i & 3) == 3) {
            return "fill";
        }
        if ((i & 1) == 1) {
            return "top";
        }
        if ((i & 2) == 2) {
            return "bottom";
        }
        return "center";
    }

    public void setExpand(Component comp, String ex) {
        Integer it = (Integer)this.alignmentTable.get(comp);
        int i = this.align;
        if (it != null) {
            i = it;
        }
        if ("x".equalsIgnoreCase(ex)) {
            i |= 0x20;
        } else if ("y".equalsIgnoreCase(ex)) {
            i |= 0x10;
        } else if ("xy".equalsIgnoreCase(ex)) {
            i |= 0x20;
            i |= 0x10;
        }
        this.alignmentTable.put(comp, PnutsLayout.getInteger(i));
        this.invalidateLayout(comp.getParent());
    }

    public String getExpand(Component comp) {
        Integer it = (Integer)this.alignmentTable.get(comp);
        int i = this.align;
        if (it != null) {
            i = it;
        }
        if ((i & 0x30) == 48) {
            return "xy";
        }
        if ((i & 0x20) == 32) {
            return "x";
        }
        if ((i & 0x10) == 16) {
            return "y";
        }
        return "";
    }

    public void setPadding(Component comp, int x, int y) {
        this.padTable.put(comp, new Object[]{PnutsLayout.getInteger(x), PnutsLayout.getInteger(y)});
        this.invalidateLayout(comp.getParent());
    }

    public int getPadX(Component comp) {
        Object[] pair = (Object[])this.padTable.get(comp);
        if (pair != null) {
            return (Integer)pair[0];
        }
        return 0;
    }

    public int getPadY(Component comp) {
        Object[] pair = (Object[])this.padTable.get(comp);
        if (pair != null) {
            return (Integer)pair[1];
        }
        return 0;
    }

    public void setIPadding(Component comp, int x, int y) {
        this.iPadTable.put(comp, new Object[]{PnutsLayout.getInteger(x), PnutsLayout.getInteger(y)});
        this.invalidateLayout(comp.getParent());
    }

    public int getIPadX(Component comp) {
        Object[] pair = (Object[])this.iPadTable.get(comp);
        if (pair != null) {
            return (Integer)pair[0];
        }
        return 0;
    }

    public int getIPadY(Component comp) {
        Object[] pair = (Object[])this.iPadTable.get(comp);
        if (pair != null) {
            return (Integer)pair[1];
        }
        return 0;
    }

    void clear(int[] array, int len) {
        int i;
        for (i = 0; i <= len - zero.length; i += zero.length) {
            System.arraycopy(zero, 0, array, i, zero.length);
        }
        System.arraycopy(zero, 0, array, i, len - i);
    }

    void bindContainer(Container target) {
        int i;
        int j;
        int _m;
        if (this.valid) {
            return;
        }
        BitSet[] map = new BitSet[this.cols];
        for (int i2 = 0; i2 < this.cols; ++i2) {
            map[i2] = new BitSet();
        }
        int nmembers = target.getComponentCount();
        int _k = 0;
        int _j = 0;
        int _l = 0;
        if (this.pos_x.length < nmembers) {
            this.pos_x = new int[nmembers * 2];
        }
        if (this.pos_y.length < nmembers) {
            this.pos_y = new int[nmembers * 2];
        }
        this.clear(this.pos_x, nmembers);
        this.clear(this.pos_y, nmembers);
        for (int i3 = 0; i3 < nmembers; ++i3) {
            Component comp = target.getComponent(i3);
            Object[] p = (Object[])this.spanTable.get(comp);
            int colspan = 1;
            int rowspan = 1;
            if (p != null) {
                colspan = (Integer)p[0];
                rowspan = (Integer)p[1];
            }
            while (!this.fit(_j, _k, colspan, rowspan, map)) {
                if (++_j < this.cols) continue;
                _j = 0;
                ++_k;
            }
            this.pos_y[i3] = _k;
            this.pos_x[i3] = _j;
            for (int jj = 0; jj < colspan; ++jj) {
                for (int kk = 0; kk < rowspan; ++kk) {
                    map[_j + jj].set(_k + kk);
                }
            }
            if (_l < _k + rowspan) {
                _l = _k + rowspan;
            }
            if (++_j < this.cols) continue;
            _j = 0;
            ++_k;
        }
        this.rows = _l;
        this.grid_x = new int[this.cols + 1];
        this.grid_y = new int[this.rows + 1];
        this.widths = new int[this.cols];
        this.heights = new int[this.rows];
        this.vfit = new int[this.rows];
        this.hfit = new int[this.cols];
        int wmax = 0;
        int hmax = 0;
        int j2 = 0;
        int k = 0;
        for (int i4 = 0; i4 < nmembers; ++i4) {
            int ii;
            int ii2;
            Component m = target.getComponent(i4);
            Dimension d = m.getPreferredSize();
            int d_width = d.width;
            int d_height = d.height;
            Object[] ip = (Object[])this.iPadTable.get(m);
            if (ip != null) {
                d_width = d.width + (Integer)ip[0];
                d_height = d.height + (Integer)ip[1];
            }
            Object[] pd = (Object[])this.padTable.get(m);
            int px = this.padx;
            int py = this.pady;
            if (pd != null) {
                px = (Integer)pd[0];
                py = (Integer)pd[1];
            }
            k = this.pos_y[i4];
            j2 = this.pos_x[i4];
            int colspan = 1;
            int rowspan = 1;
            Object[] p = (Object[])this.spanTable.get(m);
            if (p != null) {
                colspan = (Integer)p[0];
                rowspan = (Integer)p[1];
            }
            int wc = 0;
            for (ii2 = 0; ii2 < colspan; ++ii2) {
                wc += this.widths[j2 + ii2];
            }
            if (wc < d_width + px * 2) {
                for (ii2 = 0; ii2 < colspan; ++ii2) {
                    int n = j2 + ii2;
                    this.widths[n] = this.widths[n] + (d_width + px * 2 - wc) / colspan;
                    if (!this.xfix || wmax >= this.widths[j2 + ii2]) continue;
                    wmax = this.widths[j2 + ii2];
                }
            }
            if (this.heights[k] < (d_height + py * 2) / rowspan) {
                this.heights[k] = (d_height + py * 2) / rowspan;
                if (this.yfix && hmax < this.heights[k]) {
                    hmax = this.heights[k];
                }
            }
            Object val = this.alignmentTable.get(m);
            int al = this.align;
            if (val != null && val instanceof Integer) {
                al = (Integer)val;
            }
            if ((al & 0x20) != 0) {
                for (ii = 0; ii < colspan; ++ii) {
                    int n = j2 + ii;
                    this.hfit[n] = this.hfit[n] | 1;
                }
            }
            if ((al & 0x10) != 0) {
                for (ii = 0; ii < rowspan; ++ii) {
                    int n = k + ii;
                    this.vfit[n] = this.vfit[n] | 1;
                }
            }
            if ((j2 += colspan) < this.cols) continue;
            j2 = 0;
            ++k;
        }
        if (this.xfix) {
            for (_m = 0; _m < this.cols; ++_m) {
                this.widths[_m] = wmax;
            }
        }
        if (this.yfix) {
            for (_m = 0; _m < this.rows; ++_m) {
                this.heights[_m] = hmax;
            }
        }
        int w = 0;
        int h = 0;
        for (j = 0; j < this.cols; ++j) {
            w += this.widths[j];
        }
        for (j = 0; j < this.rows; ++j) {
            h += this.heights[j];
        }
        this.hfits = 0;
        for (i = 0; i < this.hfit.length; ++i) {
            if ((this.hfit[i] & 1) == 0) continue;
            ++this.hfits;
        }
        this.vfits = 0;
        for (i = 0; i < this.vfit.length; ++i) {
            if ((this.vfit[i] & 1) == 0) continue;
            ++this.vfits;
        }
        Insets insets = target.getInsets();
        this.psize = new Dimension(w += insets.left + insets.right + this.padx * this.cols, h += insets.top + insets.bottom + this.pady * this.rows);
        this.valid = true;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        this.bindContainer(target);
        return this.psize;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public void layoutContainer(Container target) {
        int i;
        int w;
        Insets insets = target.getInsets();
        int nmembers = target.getComponentCount();
        this.bindContainer(target);
        int tw = target.getSize().width;
        int th = target.getSize().height;
        int pw = this.psize.width;
        int ph = this.psize.height;
        int aw = 0;
        int ah = 0;
        if (this.hfits > 0) {
            aw = (tw - pw) / this.hfits;
        }
        if (this.vfits > 0) {
            ah = (th - ph) / this.vfits;
        }
        int h = insets.top;
        this.grid_x[0] = w = insets.left;
        for (i = 1; i <= this.cols; ++i) {
            this.grid_x[i] = this.grid_x[i - 1] + this.widths[i - 1] + this.padx;
            if ((this.hfit[i - 1] & 1) == 0) continue;
            int n = i;
            this.grid_x[n] = this.grid_x[n] + aw;
        }
        this.grid_y[0] = h;
        for (i = 1; i <= this.rows; ++i) {
            this.grid_y[i] = this.grid_y[i - 1] + this.heights[i - 1] + this.pady;
            if ((this.vfit[i - 1] & 1) == 0) continue;
            int n = i;
            this.grid_y[n] = this.grid_y[n] + ah;
        }
        int j = 0;
        int k = 0;
        for (i = 0; i < nmembers; ++i) {
            int y;
            int x;
            Component m = target.getComponent(i);
            Dimension d = m.getPreferredSize();
            int d_width = d.width;
            int d_height = d.height;
            Object[] ip = (Object[])this.iPadTable.get(m);
            if (ip != null) {
                d_width = d.width + (Integer)ip[0];
                d_height = d.height + (Integer)ip[1];
            }
            k = this.pos_y[i];
            j = this.pos_x[i];
            int colspan = 1;
            int rowspan = 1;
            Object[] p = (Object[])this.spanTable.get(m);
            if (p != null) {
                colspan = (Integer)p[0];
                rowspan = (Integer)p[1];
            }
            int al = this.align;
            Object val = this.alignmentTable.get(m);
            if (val != null && val instanceof Integer) {
                al = (Integer)val;
            }
            int dw = d_width;
            int dh = d_height;
            Object[] pt = (Object[])this.padTable.get(m);
            int px = this.padx;
            int py = this.pady;
            if (pt != null) {
                px = (Integer)pt[0];
                py = (Integer)pt[1];
            }
            if ((al & 4) != 0) {
                x = this.grid_x[j] + px;
                if ((al & 8) != 0) {
                    dw = this.grid_x[j + colspan] - this.grid_x[j] - px * 2;
                }
            } else {
                x = (al & 8) != 0 ? this.grid_x[j + colspan] - dw - px : (this.grid_x[j] + this.grid_x[j + colspan] - dw) / 2;
            }
            if ((al & 1) != 0) {
                y = this.grid_y[k] + py;
                if ((al & 2) != 0) {
                    dh = this.grid_y[k + rowspan] - this.grid_y[k] - py * 2;
                }
            } else {
                y = (al & 2) != 0 ? this.grid_y[k + rowspan] - dh - py : (this.grid_y[k] + this.grid_y[k + rowspan] - dh) / 2;
            }
            m.setBounds(x, y, dw, dh);
        }
    }

    boolean fit(int x, int y, int c, int r, BitSet[] map) {
        for (int i = 0; i < c; ++i) {
            for (int j = 0; j < r; ++j) {
                if (x + i >= this.cols) {
                    return false;
                }
                if (!map[x + i].get(y + j)) continue;
                return false;
            }
        }
        return true;
    }

    static Hashtable str2table(String str) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(t, "= ");
            String key = st2.nextToken();
            String value = st2.nextToken();
            table.put(key, value);
        }
        return table;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        if (!this.valid) {
            throw new RuntimeException("PnutsLayout not valid");
        }
        return this.rows;
    }

    public Point getGridPoint(Container target, int x, int y) {
        if (!this.valid) {
            return null;
        }
        return new Point(this.grid_x[x], this.grid_y[y]);
    }

    public Rectangle getGridRectangle(Container target, int idx) {
        if (!this.valid) {
            return null;
        }
        int x = this.pos_x[idx];
        int y = this.pos_y[idx];
        int gx = this.grid_x[x];
        int gy = this.grid_y[y];
        Object[] s = (Object[])this.spanTable.get(target.getComponent(idx));
        int sx = 1;
        int sy = 1;
        if (s != null) {
            sx = (Integer)s[0];
            sy = (Integer)s[1];
        }
        return new Rectangle(gx, gy, this.grid_x[x + sx] - gx, this.grid_y[y + sy] - gy);
    }

    public String toString() {
        return this.getClass().getName() + "[cols=" + this.cols + ",padx=" + this.padx + ",pady=" + this.pady + ",ipadx=" + this.ipadx + ",ipady=" + this.ipady + "]";
    }

    static {
        int i;
        integer = new Integer[33];
        for (i = 0; i < integer.length; ++i) {
            PnutsLayout.integer[i] = new Integer(i);
        }
        zero = new int[16];
        for (i = 0; i < zero.length; ++i) {
            PnutsLayout.zero[i] = 0;
        }
    }
}

