/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentStatus;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ArgInputPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.CommandListPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ComponentTree;
import org.lsst.ccs.gconsole.plugins.commandbrowser.HTMLTextPane;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public final class AgentPanel
extends JSplitPane
implements Savable,
ChangeListener {
    private AgentStatus agent;
    final ComponentTree componentTree;
    private final CommandListPanel commandListPanel;
    private final ArgInputPanel argInputPanel;
    private final HTMLTextPane resultPane;
    private final CommandSender sender;
    private final JCheckBox hideLockedBox;
    private final JCheckBox hideSystemBox;
    private final JTextField timeoutField;
    private final JProgressBar progressBar;
    Descriptor descriptor;
    private CommandTask lastCommand;
    private long lastCommandStart;

    public AgentPanel() {
        super(0);
        this.setContinuousLayout(true);
        this.descriptor = new Descriptor();
        this.sender = Console.getConsole().getSingleton(CommandService.class).getSender();
        this.sender.setCommandHandle(new BrowserCommandHandle());
        JPanel topPane = new JPanel(new GridLayout(1, 3));
        this.setTopComponent(topPane);
        this.resultPane = new HTMLTextPane();
        this.setBottomComponent(new JScrollPane(this.resultPane));
        this.componentTree = new ComponentTree(this);
        topPane.add(new JScrollPane(this.componentTree));
        this.commandListPanel = new CommandListPanel(this);
        topPane.add(new JScrollPane(this.commandListPanel));
        this.componentTree.addTreeSelectionListener(this.commandListPanel);
        JPanel topPaneRightPanel = new JPanel(new BorderLayout());
        topPane.add(topPaneRightPanel);
        this.argInputPanel = new ArgInputPanel();
        topPaneRightPanel.add((Component)this.argInputPanel, "Center");
        this.commandListPanel.addListSelectionListener(this.argInputPanel);
        JPanel controlPane = new JPanel(new GridBagLayout());
        topPaneRightPanel.add((Component)controlPane, "South");
        controlPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.hideLockedBox = new JCheckBox("Hide locked");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        controlPane.add((Component)this.hideLockedBox, c);
        this.hideLockedBox.setToolTipText("Hide commands unavailable due to agent lock state");
        this.hideLockedBox.setSelected(this.descriptor.isHideLocked());
        this.hideLockedBox.addActionListener(e -> {
            this.descriptor.setHideLocked(((JCheckBox)e.getSource()).isSelected());
            this.componentTree.updateData(this.agent);
        });
        this.hideSystemBox = new JCheckBox("Hide system");
        c.gridx = 0;
        c.gridy = 1;
        controlPane.add((Component)this.hideSystemBox, c);
        this.hideSystemBox.setToolTipText("Hide system commands");
        this.hideSystemBox.setSelected(this.descriptor.isHideSystem());
        this.hideSystemBox.addActionListener(e -> {
            this.descriptor.setHideSystem(((JCheckBox)e.getSource()).isSelected());
            this.componentTree.updateData(this.agent);
        });
        JButton sendCmdButton = new JButton(new ImageIcon(this.getClass().getResource("ic_send_black_24dp.png")));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 13;
        controlPane.add((Component)sendCmdButton, c);
        sendCmdButton.setText("Send");
        sendCmdButton.setEnabled(false);
        sendCmdButton.addActionListener(e -> this.sendCommand());
        Box timeoutPanel = Box.createHorizontalBox();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 5, 0);
        c.anchor = 17;
        c.fill = 0;
        controlPane.add((Component)timeoutPanel, c);
        timeoutPanel.add(new JLabel("Timeout:"));
        timeoutPanel.add(Box.createRigidArea(Const.HDIM));
        this.timeoutField = new JTextField(Integer.toString(this.descriptor.getTimeout()), 4);
        timeoutPanel.add(this.timeoutField);
        this.timeoutField.addActionListener(e -> this.setTimeout());
        this.timeoutField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AgentPanel.this.setTimeout();
            }
        });
        timeoutPanel.add(new JLabel(" seconds."));
        timeoutPanel.add(Box.createHorizontalGlue());
        this.progressBar = new JProgressBar(0, this.descriptor.getTimeout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        controlPane.add((Component)this.progressBar, c);
        this.commandListPanel.addListSelectionListener(e -> {
            boolean en = this.commandListPanel.isVisibleCommandSelected();
            sendCmdButton.setEnabled(en);
            this.argInputPanel.setEnabled(en);
        });
    }

    void setAgent(AgentStatus agent) {
        if (this.agent != null) {
            this.agent.removeListener(this);
        }
        this.agent = agent;
        if (agent != null) {
            agent.addListener(this);
        }
        this.componentTree.updateData(agent);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.agent == null || !this.agent.isAdjusting()) {
            this.componentTree.updateData(this.agent);
        }
    }

    private void sendCommand() {
        String path = this.componentTree.getSelectedPathAsString();
        DictionaryCommand cmd = (DictionaryCommand)this.commandListPanel.getSelectedValue();
        if (path != null && cmd != null) {
            String s = this.argInputPanel.getFormattedArgumentValues();
            Object[] args = this.argInputPanel.getFormattedValues();
            String commandName = cmd.getCommandName();
            String command = path + "/" + commandName;
            this.resultPane.insertHTML("<b>> " + path + " " + commandName + " " + s + " ...</b>");
            this.progressBar.setMaximum(this.descriptor.getTimeout() * 1000);
            this.progressBar.setValue(0);
            this.progressBar.setString(null);
            this.lastCommandStart = System.currentTimeMillis();
            this.lastCommand = this.sender.execute(command, args);
            Progress prog = new Progress(this.lastCommand);
            PeriodicTask task = new PeriodicTask(Console.getConsole().getScheduler(), (Runnable)prog, true, "Com browser progress bar", Level.SEVERE, 500L, TimeUnit.MILLISECONDS);
            prog.setPeriodicTask(task);
            task.start(500L, TimeUnit.MILLISECONDS);
        }
    }

    private void setTimeout() {
        try {
            int t = Integer.parseInt(this.timeoutField.getText());
            if (t > 0 && t < 9999) {
                this.descriptor.setTimeout(t);
                this.sender.setTimeout(Duration.ofSeconds(t));
            } else {
                this.timeoutField.setText(Integer.toString(this.descriptor.getTimeout()));
            }
        }
        catch (NumberFormatException x) {
            this.timeoutField.setText(Integer.toString(this.descriptor.getTimeout()));
        }
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        } else if (descriptor == null) {
            this.descriptor = new Descriptor();
        }
        this.hideLockedBox.setSelected(this.descriptor.isHideLocked());
        this.hideSystemBox.setSelected(this.descriptor.isHideSystem());
        int timeout = this.descriptor.getTimeout();
        this.timeoutField.setText(Integer.toString(timeout));
        this.sender.setTimeout(Duration.ofSeconds(timeout));
    }

    @Override
    public Descriptor save() {
        return this.descriptor.clone();
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private boolean hideLocked;
        private boolean hideSystem = true;
        private int timeout = 10;

        public boolean isHideLocked() {
            return this.hideLocked;
        }

        public void setHideLocked(boolean hideLocked) {
            this.hideLocked = hideLocked;
        }

        public boolean isHideSystem() {
            return this.hideSystem;
        }

        public void setHideSystem(boolean hideSystem) {
            this.hideSystem = hideSystem;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public Descriptor clone() {
            try {
                return (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                throw new RuntimeException();
            }
        }
    }

    private class Progress
    implements Runnable {
        CommandTask commandTask;
        PeriodicTask periodicTask;

        Progress(CommandTask commandTask) {
            this.commandTask = commandTask;
        }

        void setPeriodicTask(PeriodicTask periodicTask) {
            this.periodicTask = periodicTask;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(() -> {
                if (AgentPanel.this.lastCommand == this.commandTask) {
                    int progress = (int)(System.currentTimeMillis() - AgentPanel.this.lastCommandStart);
                    AgentPanel.this.progressBar.setValue(progress);
                } else {
                    this.periodicTask.cancel(false);
                }
            });
        }
    }

    private class BrowserCommandHandle
    implements CommandHandle {
        private BrowserCommandHandle() {
        }

        @Override
        public void onSendingFailure(Throwable t, CommandTask source) {
            StringBuilder sb = new StringBuilder("<font color=\"#FF0000\">");
            if (t == null) {
                sb.append("Cannot send command.");
            } else {
                sb.append(this.shorten(t.getMessage()));
            }
            AgentPanel.this.resultPane.insertHTML(sb.append("</font>").toString());
            this.resetProgressBar(source);
        }

        @Override
        public void onAck(CommandAck ack, CommandTask source) {
            if (source == AgentPanel.this.lastCommand) {
                AgentPanel.this.progressBar.setForeground(Color.GREEN);
                AgentPanel.this.progressBar.setString("received");
                Duration customTimeout = ack.getTimeout();
                if (customTimeout != null) {
                    long current = System.currentTimeMillis();
                    int total = (int)(current - AgentPanel.this.lastCommandStart + customTimeout.toMillis());
                    AgentPanel.this.progressBar.setMaximum(total);
                    int progress = (int)(current - AgentPanel.this.lastCommandStart);
                    AgentPanel.this.progressBar.setValue(progress);
                }
            }
        }

        @Override
        public void onNack(CommandNack nack, CommandTask source) {
            String message;
            StringBuilder sb = new StringBuilder("<font color=\"#FF0000\">");
            sb.append("Command rejected");
            if (nack != null && (message = this.shorten(nack.getReason())) != null && !message.isEmpty()) {
                sb.append(": ").append(message);
            }
            AgentPanel.this.resultPane.insertHTML(sb.append("</font>").toString());
            this.resetProgressBar(source);
        }

        @Override
        public void onSuccess(Object res, CommandTask source) {
            if (res == null) {
                AgentPanel.this.resultPane.insertHTML("Done.");
            } else {
                if (res.getClass().isArray()) {
                    try {
                        res = Arrays.deepToString((Object[])res);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                AgentPanel.this.resultPane.insertHTML(res.toString().replaceAll("(\\r\\n|\\n)", "<br />"));
            }
            this.resetProgressBar(source);
        }

        @Override
        public void onExecutionFailure(Throwable t, CommandTask source) {
            this.resetProgressBar(source);
            StringBuilder sb = new StringBuilder("<font color=\"#FF0000\">");
            if (t instanceof Exception) {
                sb.append(this.shorten(t.getMessage()));
                Console.getConsole().error(source.getCommand() + " command submitted through the command browser resulted in execution exception.", (Exception)t);
            } else {
                sb.append("Failed.");
            }
            AgentPanel.this.resultPane.insertHTML(sb.append("</font>").toString());
        }

        @Override
        public void onTimeout(TimeoutException x, CommandTask source) {
            AgentPanel.this.resultPane.insertHTML("<font color=\"#FF0000\">" + this.shorten(x.getMessage()) + "</font>");
            this.resetProgressBar(source);
        }

        @Override
        public void onCancel(CancellationException exception, CommandTask source) {
            AgentPanel.this.resultPane.insertHTML("Cancelled.");
            this.resetProgressBar(source);
        }

        @Override
        public void onResult(Object res, CommandTask source) {
            AgentPanel.this.resultPane.insertHTML("Result: " + (res == null ? "" : res));
            this.resetProgressBar(source);
        }

        private void resetProgressBar(CommandTask source) {
            if (source == AgentPanel.this.lastCommand) {
                AgentPanel.this.progressBar.setValue(0);
                AgentPanel.this.lastCommand = null;
            }
        }
    }
}

