/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import java.awt.Component;
import java.util.Vector;
import tablelayout.TableLocRec;

public class TableLoc {
    private static final String version_id = "@(#)$Id: TableLoc.java 11553 2007-06-05 22:06:23Z duns $ Copyright West Consulting bv";
    Vector compinfo = new Vector();
    Vector recinfo = new Vector();
    static final String CHAR_SEMI = ";";
    static final String CHAR_BLANC = " ";
    static final String CHAR_ALL = "; ";
    static final String COMPONENT_REC = "rec";
    static final String COMPONENT_NEXT = "next";
    static final String COMPONENT_PREV = "prev";

    public void addElement(TableLocRec rec, Component comp) {
        this.compinfo.addElement(comp);
        this.recinfo.addElement(rec);
    }

    public void addElement(TableLoc loc) {
        int sz = loc.size();
        for (int index = 0; index < sz; ++index) {
            this.compinfo.addElement(loc.compinfo.elementAt(index));
            this.recinfo.addElement(loc.recinfo.elementAt(index));
        }
    }

    public void removeElement(Component comp) {
        int index = this.compinfo.indexOf(comp);
        if (index > -1) {
            this.compinfo.removeElementAt(index);
            this.recinfo.removeElementAt(index);
        }
    }

    public int size() {
        return this.compinfo.size();
    }

    public TableLocRec recElementAt(int index) {
        return (TableLocRec)this.recinfo.elementAt(index);
    }

    public Component compElementAt(int index) {
        return (Component)this.compinfo.elementAt(index);
    }

    public TableLocRec element(Component w) {
        int index = this.compinfo.indexOf(w);
        if (index > -1) {
            return (TableLocRec)this.recinfo.elementAt(index);
        }
        return null;
    }

    public int numCols() {
        TableLocRec rec = null;
        int cols = 0;
        int sz = this.compinfo.size();
        for (int index = 0; index < sz; ++index) {
            rec = (TableLocRec)this.recinfo.elementAt(index);
            if (cols >= rec.col + rec.col_span) continue;
            cols = rec.col + rec.col_span;
        }
        return cols;
    }

    public int numRows() {
        TableLocRec rec = null;
        int rows = 0;
        int sz = this.compinfo.size();
        for (int index = 0; index < sz; ++index) {
            rec = (TableLocRec)this.recinfo.elementAt(index);
            if (rows >= rec.row + rec.row_span) continue;
            rows = rec.row + rec.row_span;
        }
        return rows;
    }

    public void qsort(int left, int right, boolean do_col) {
        if (left >= right) {
            return;
        }
        this.swap(left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (do_col) {
                if (TableLocRec.compareColSpan((TableLocRec)this.recinfo.elementAt(i), (TableLocRec)this.recinfo.elementAt(left)) < 0) {
                    this.swap(last, i);
                }
            } else if (TableLocRec.compareRowSpan((TableLocRec)this.recinfo.elementAt(i), (TableLocRec)this.recinfo.elementAt(left)) < 0) {
                this.swap(last, i);
            }
            ++last;
        }
        this.swap(left, last);
        this.qsort(left, last - 1, do_col);
        this.qsort(last + 1, right, do_col);
    }

    public void swap(int one, int two) {
        Component com2;
        TableLocRec rec2;
        TableLocRec trec = (TableLocRec)this.recinfo.elementAt(one);
        TableLocRec rec1 = (TableLocRec)this.recinfo.elementAt(one);
        trec = rec2 = (TableLocRec)this.recinfo.elementAt(two);
        rec2 = rec1;
        rec1 = trec;
        Component tcom = (Component)this.compinfo.elementAt(one);
        Component com1 = (Component)this.compinfo.elementAt(one);
        tcom = com2 = (Component)this.compinfo.elementAt(two);
        com2 = com1;
        com1 = tcom;
    }

    public Object clone() {
        TableLoc elem = new TableLoc();
        elem.compinfo = (Vector)this.compinfo.clone();
        elem.recinfo = (Vector)this.recinfo.clone();
        return elem;
    }

    public String toString() {
        return "TableLoc [\ncompinfo " + this.compinfo.toString() + "\nrecinfo " + this.recinfo.toString() + "]";
    }
}

