package org.lsst.ccs.subsystem.common.ui.jas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.gconsole.base.filter.GenericFilterPersistable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Generic path-oriented monitoring filter.
 *
 * @author The LSST CCS Team
 */
public class PathMonitorFilter extends GenericFilterPersistable {

    private static final List<String> FIELDS = new ArrayList<>();
    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
    }

    private final Set<String> exclusions = new HashSet<>();

    public PathMonitorFilter(List<String> agents, String... exclSections) {
        super("MyName", agents, Collections.singletonList("/"), "", true, FIELDS);
        exclusions.add("state");
        exclusions.add("configuration");
        exclusions.add("runtimeInfo");
        exclusions.add("config");
        exclusions.add("ccsVersions");
        exclusions.addAll(Arrays.asList(exclSections));
    }

    @Override
    public String getDisplayPath(AgentChannel channel) {
        String path = channel.getLocalPath();
        int i1 = path.indexOf("/");
        if (i1 != -1) {
            String section = path.substring(0, i1).trim();
            if (section.equals("main")) {
                int i2 = path.indexOf("/", i1 + 1);
                if (i2 != -1) {
                    section = path.substring(i1 + 1, i2);
                    i1 = i2;
                }
            }
            if (!exclusions.contains(section)) {
                return section + "//" + path.substring(i1 + 1);
            }
            else {
                return null;
            }
        }
        else {
            return "//" + path;
        }
    }

}
