/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.Hibernate;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class WrapperOptionsImpl
implements WrapperOptions {
    private final SessionImplementor session;
    private final boolean useStreamForLobBinding;

    public WrapperOptionsImpl(SessionImplementor session) {
        this.session = session;
        this.useStreamForLobBinding = Environment.useStreamsForBinary() || session.getFactory().getDialect().useInputStreamToInsertBlob();
    }

    @Override
    public boolean useStreamForLobBinding() {
        return this.useStreamForLobBinding;
    }

    @Override
    public LobCreator getLobCreator() {
        return Hibernate.getLobCreator(this.session);
    }

    @Override
    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        SqlTypeDescriptor remapped = sqlTypeDescriptor.canBeRemapped() ? this.session.getFactory().getDialect().remapSqlTypeDescriptor(sqlTypeDescriptor) : sqlTypeDescriptor;
        return remapped == null ? sqlTypeDescriptor : remapped;
    }
}

