package org.lsst.ccs.subsystem.common.ui.focalplane.view;

import java.util.List;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;

/**
 * An adaptor to simplify implementing focal plane monitor views.
 *
 * @author onoprien
 */
public interface FocalPlaneView extends PersistableMonitorView {

// -- Fields : -----------------------------------------------------------------

    static public final String CATEGORY = "FocalPlaneView";


// -- Override GroupView : -----------------------------------------------------

    @Override
    FocalPlaneFilter getFilter();
    
    @Override
    default String getGroup(String displayPath) {
        return Segment.stripPathPrefix(displayPath);
    }

    @Override
    default List<String> getGroups() {
        FocalPlaneFilter f = getFilter();
        if (f != null) {
            List<String> groups = f.getGroups();
            if (groups != null) return groups;
        }
        return PersistableMonitorView.super.getGroups();
    }


// -- Override Persistable : ---------------------------------------------------

//    /**
//     * Returns the {@link Persistable} category this filter belongs to.
//     * <p>
//     * The implementation provided by this class returns {@link #CATEGORY}.
//     * 
//     * @return Category of this {@code Persistable}.
//     */
//    @Override
//    default String getCategory() {
//        return CATEGORY;
//    }
    
    
// -- Descriptor : -------------------------------------------------------------
    
    static public class Descriptor extends PersistableMonitorView.Descriptor {
        public Descriptor() {
            setCategory(CATEGORY);
        }
    }

}
