package org.lsst.ccs.subsystem.common.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

/**
 *  Implements the system status line sub-panel.
 *
 *  This needs to be incorporated into a "top-level" panel
 *
 *  @author Owen Saxton
 */
public class SystemStatusPanel extends JPanel implements UiUtilities.ActionHandler {

    private static final int statusWidth = UiUtilities.maxLabelWidth(new String[]{"STOPPED", "RUNNING"}, "");

    private final CommandSender sender;
    private final String node, command;
    private final UiUtilities uiUtils;
    private JLabel stateStatus;
    private TextFieldX periodTextField;

    public SystemStatusPanel(CommandSender sender) {
        this(sender, null, "setUpdatePeriod");
    }

    public SystemStatusPanel(CommandSender sender, String node) {
        this(sender, node, "setPublishPeriod");
    }

    private SystemStatusPanel(CommandSender sender, String node, String command) {
        this.sender = sender;
        this.node = node;
        this.command = command;
        uiUtils = new UiUtilities(this);
        initComponents();
        disablePanel();
    }

    public void updatePanel(int tickMillis) {
        stateStatus.setText("RUNNING");
        stateStatus.setForeground(UiConstants.GREEN);
        periodTextField.update(tickMillis / 1000.0, true);
    }

    public void disablePanel() {
        stateStatus.setText("STOPPED");
        stateStatus.setForeground(UiConstants.RED);
        periodTextField.setDisabled();
    }

    private void initComponents() {
        stateStatus = UiUtilities.newLabel("XXX", statusWidth);
        periodTextField = uiUtils.newTextFieldX("99999.9", "", TextFieldX.TYPE_DOUBLE, true);

        setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 5, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = GridBagConstraints.WEST;
        add(UiUtilities.newLabel("System State: ", 0), gbh);
        gbh.gridx++;
        add(stateStatus, gbh);
        gbh.gridx++;
        gbh.insets.left = 72;
        add(UiUtilities.newLabel("Update Period: ", 0), gbh);
        gbh.gridx++;
        gbh.insets.left = 5;
        gbh.insets.top -= 2;
        add(periodTextField, gbh);
        gbh.gridx++;
        gbh.insets.top += 2;
        add(UiUtilities.newLabel("sec", 0), gbh);
    }

    @Override
    public void handleTextFieldX(String name, Object value) {
        sender.sendCommand(node, command, (int)(1000 * (Double)value));
    }

    private static final long serialVersionUID = 1L;
}
