package org.lsst.ccs.subsystem.common.ui;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
//import org.lsst.ccs.subsystem.common.ui.jas.CommandSender.CommandId;
import org.lsst.ccs.subsystem.common.data.BasicState;

/**
 *  Implements a minimal control panel.
 *
 *  @author Owen Saxton
 */
public class BasicControlPanel extends JPanel implements CommandSender.ReplyHandler {

    private final CommandSender sender;
    private SystemStatusPanel statusPanel;

    public BasicControlPanel(String subsys) {
        this.sender = new CommandSender(subsys, this);
        initComponents();
        (new DisableControlPanel()).run();
    }

    public void initControlPanel() {
        sender.sendCommand(true, null, "getFullState");
    }

    @Override
    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        updateControlPanel((BasicState)reply);
    }

    public void updateControlPanel(BasicState state) {
        SwingUtilities.invokeLater(new UpdateControlPanel(state));
    }

    public void disableControlPanel() {
        SwingUtilities.invokeLater(new DisableControlPanel());
    }

    private void initComponents()
    {
        statusPanel = new SystemStatusPanel(sender);
        add(statusPanel);
    }

    class UpdateControlPanel implements Runnable {

        private final BasicState state;

        UpdateControlPanel(BasicState state) {
            this.state = state;
        }

        @Override
        public void run() {
            statusPanel.updatePanel(state.getTickMillis());
            repaint();
        }

    }

    class DisableControlPanel implements Runnable {

        @Override
        public void run() {
            statusPanel.disablePanel();
            repaint();
        } 
    }

    private static final long serialVersionUID = 1L;
}
