/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public enum Segment {
    RAFT(3, 3, DataProviderInfo.Attribute.RAFT_ID.getName(), "R"),
    REB(3, 1, DataProviderInfo.Attribute.REB_ID.getName(), "Reb"),
    CCD(1, 3, DataProviderInfo.Attribute.SENSOR_ID.getName(), "S"),
    AMP(2, 8, DataProviderInfo.Attribute.AMPLIFIER_ID.getName(), "Seg");

    final int nX;
    final int nY;
    final String key;
    final String path;
    public static final String AGENT_GROUP = "agent";
    public static final String GROUP_GROUP = "group";
    public static final Pattern FP_PATH_PATTERN;
    public static final int[] N;

    private Segment(int nX, int nY, String key, String path) {
        this.nX = nX;
        this.nY = nY;
        this.key = key;
        this.path = path;
    }

    public int getNX() {
        return this.nX;
    }

    public int getNY() {
        return this.nY;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.path;
    }

    public static int[] getIndices(AgentChannel channel) {
        return Segment.getIndices(channel.getPath());
    }

    public static int[] getIndices(String path) {
        Matcher m = FP_PATH_PATTERN.matcher(path);
        if (m.matches()) {
            int[] indices = new int[]{-1, -1, -1, -1, -1, -1};
            String s = m.group(RAFT.name());
            indices[0] = Integer.parseInt(s.substring(0, 1));
            indices[1] = Integer.parseInt(s.substring(1));
            s = m.group(REB.name());
            if (s != null) {
                boolean isW;
                if ("W".equals(s)) {
                    indices[2] = 0;
                    isW = true;
                } else if ("G".equals(s)) {
                    indices[2] = 1;
                    isW = false;
                } else {
                    indices[2] = Integer.parseInt(s);
                    isW = false;
                }
                s = m.group(CCD.name());
                if (s != null) {
                    indices[3] = isW ? 1 : Integer.parseInt(s.substring(1));
                    s = m.group(AMP.name());
                    if (s != null) {
                        indices[4] = Integer.parseInt(s.substring(0, 1));
                        indices[5] = Integer.parseInt(s.substring(1));
                    }
                }
            }
            return indices;
        }
        return null;
    }

    public static String getPathPrefix(int[] indices) {
        if (indices == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (indices[0] != -1) {
            sb.append((Object)RAFT).append(indices[0]).append(indices[1]).append("/");
            if (indices[2] != -1) {
                char reb = indices[0] % 4 == 0 && indices[1] % 4 == 0 ? (indices[2] == 0 ? (char)'W' : 'G') : Integer.toString(indices[2]).charAt(0);
                sb.append((Object)REB).append(reb).append("/");
                if (indices[3] != -1) {
                    sb.append((Object)CCD).append(reb);
                    if (reb != 'W') {
                        sb.append(indices[3]);
                    }
                    sb.append("/");
                    if (indices[4] != -1) {
                        sb.append((Object)AMP).append(indices[4]).append(indices[5]).append("/");
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String getPathPrefix(AgentChannel channel) {
        return Segment.getPathPrefix(Segment.getIndices(channel));
    }

    public static String getPathPrefix(String path) {
        return Segment.getPathPrefix(Segment.getIndices(path));
    }

    public static String stripPathPrefix(String path) {
        Matcher m = FP_PATH_PATTERN.matcher(path);
        if (m.matches()) {
            String group = m.group(GROUP_GROUP);
            String agent = m.group(AGENT_GROUP);
            if (agent == null) {
                if (group == null) {
                    return "";
                }
                return group;
            }
            if (group == null) {
                return agent;
            }
            return agent + "/" + group;
        }
        return path;
    }

    static {
        FP_PATH_PATTERN = Pattern.compile("(?:(?<agent>[^/]+)/+)?" + Segment.RAFT.path + "(?<" + RAFT.name() + ">[0-4]{2})(?:/+" + Segment.REB.path + "(?<" + REB.name() + ">[0-2WG]))?(?:/+" + Segment.CCD.path + "(?<" + CCD.name() + ">W|(?:[0-2WG][0-2]))(?:/+" + Segment.AMP.path + "(?<" + AMP.name() + ">[0-1][0-7]))?)?(?:/+(?<" + GROUP_GROUP + ">.+))?");
        N = new int[]{5, 5, 3, 3, 2, 8};
    }
}

