package org.lsst.ccs.subsystem.common.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.data.BasicState;
import org.lsst.ccs.subsystem.common.ui.BasicControlPanel;

/**
 *  Basic plugin code to be extended by subsystem code.
 * 
 *  @author saxton
 */
public class BasicPlugin extends ConsolePlugin {

    private final String agentProperty;
    private final String section;

    public BasicPlugin(String agentProperty, String section) {
        this.agentProperty = agentProperty;
        this.section = section;
    }

    @Override
    public void initialize() {
        OptionalPage.getService().add(new MonOptionalPage(agentProperty, BasicControl.class, section, true, "BasicState"));
    }
    
    public static class BasicControl extends ControlPanel implements StatusMessageListener {

        private BasicControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(BasicState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(String agent) {
            return ctrlPanel = new BasicControlPanel(agent);
        }

        @Override
        public void initControlPanel() {
            ctrlPanel.initControlPanel();
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((BasicState)obj);
        }

        @Override
        public void disableControlPanel() {
            ctrlPanel.disableControlPanel();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }

    }

}
