/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.plotter.DefaultPage;
import org.freehep.jas.plugin.plotter.DefaultRegion;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.jas3.JasPanelManager;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

public class TrendPage
extends DefaultPage
implements Persistable {
    public static final String CATEGORY = "TrendPage";
    private final Descriptor descriptor;
    private final LsstTrendingPlugin plugin = Console.getConsole().getSingleton(LsstTrendingPlugin.class);

    public TrendPage(String title) {
        super((Studio)Application.getApplication(), Console.getConsole().getSingleton(LsstTrendingPlugin.class).getPlotFactory(), title);
        this.descriptor = new Descriptor();
        this.createRegions(1, 1);
    }

    public TrendPage(Descriptor desc) {
        super((Studio)Application.getApplication(), Console.getConsole().getSingleton(LsstTrendingPlugin.class).getPlotFactory(), desc.getName());
        this.descriptor = desc.clone();
    }

    public void showPage() {
        if (this.context == null) {
            HashMap<String, Serializable> data;
            HashMap<Object, Object> prop = new HashMap<Object, Object>();
            DataPanelDescriptor pd = this.getDescriptor().getPanel();
            if (pd != null && (data = pd.getData()) != null) {
                prop.putAll(data);
            }
            prop.put(Panel.TITLE, this.title());
            prop.put(Panel.GROUP, this.plugin.PANEL_GROUP);
            prop.put(Panel.ICON, histogramIcon);
            prop.put(Panel.TYPE, PanelType.DATA);
            Consumer<JComponent> onSaveAs = c -> {
                PersistenceService service = this.plugin.getConsole().getSingleton(PersistenceService.class);
                service.saveAs(this.save(), "Save trending page", null);
            };
            prop.put(Panel.ON_SAVE_AS, onSaveAs);
            JasPanelManager panMan = (JasPanelManager)this.plugin.getConsole().getPanelManager();
            panMan.open((Component)((Object)this), prop);
            this.context = panMan.getContext((Component)((Object)this));
        } else {
            this.plugin.getConsole().getPanelManager().set((Component)((Object)this), Panel.SELECTED, true);
        }
    }

    public final void createRegions(int columns, int rows) {
        super.createRegions(columns, rows);
        int n = this.numberOfRegions();
        for (int i = 0; i < n; ++i) {
            PlotRegion reg = this.region(i);
            if (!(reg instanceof DefaultRegion)) continue;
            final DefaultRegion region = (DefaultRegion)reg;
            region.addPopupItems((menu, component, point) -> {
                AbstractAction act = new AbstractAction("Load Plot..."){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PersistenceService service = TrendPage.this.plugin.getConsole().getSingleton(PersistenceService.class);
                        try {
                            TrendPlotter.Descriptor desc = (TrendPlotter.Descriptor)service.load(TrendPlotter.CATEGORY, "Load trending plot", null);
                            TrendPlotter plotter = (TrendPlotter)service.make(desc);
                            LsstTrendingPlugin.showPlotter(plotter, (PlotRegion)region);
                        }
                        catch (ClassCastException | CancellationException x) {
                            System.out.println(x);
                        }
                    }
                };
                Component[] components = menu.getComponents();
                int nc = components.length;
                for (int ic = 0; ic < nc; ++ic) {
                    Component c = components[ic];
                    if (!(c instanceof JMenuItem) || !"Clear Region".equals(((JMenuItem)c).getText())) continue;
                    menu.insert(act, ic);
                }
                return menu;
            });
        }
    }

    public boolean close() {
        boolean out = super.close();
        if (out) {
            this.plugin.closePage(this);
        }
        return out;
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.getDescriptor().clone();
        desc.setName(this.title());
        desc.setRows(this.rows());
        desc.setColumns(this.columns());
        int n = this.numberOfRegions();
        ArrayList<TrendPlotter.Descriptor> plotterDescriptors = new ArrayList<TrendPlotter.Descriptor>(n);
        for (int i = 0; i < n; ++i) {
            TrendPlotter.Descriptor plotterDescriptor;
            Plotter plotter;
            PlotRegion region = this.region(i);
            if (region == null || (plotter = region.currentPlot()) == null || !(plotter instanceof TrendPlotter) || (plotterDescriptor = ((TrendPlotter)plotter).save()) == null) continue;
            plotterDescriptors.add(plotterDescriptor);
        }
        desc.setPlotters(plotterDescriptors.toArray(new TrendPlotter.Descriptor[0]));
        DataPanelDescriptor pd = DataPanelDescriptor.get((JComponent)((Object)this));
        desc.setPanel(pd);
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor d) {
        if (d instanceof Descriptor) {
            Descriptor desc = (Descriptor)d;
            int rows = desc.getRows();
            int columns = desc.getColumns();
            this.createRegions(columns, rows);
            int i = 0;
            for (TrendPlotter.Descriptor plotterDescriptor : desc.getPlotters()) {
                TrendPlotter plotter = new TrendPlotter();
                LsstTrendingPlugin.showPlotter(plotter, this.region(i++));
                plotter.restore(plotterDescriptor);
            }
        }
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private int rows;
        private int columns;
        private TrendPlotter.Descriptor[] plotters;
        private DataPanelDescriptor panel;

        @Override
        public String getCategory() {
            return TrendPage.CATEGORY;
        }

        @Override
        public void setCategory(String category) {
        }

        public TrendPlotter.Descriptor[] getPlotters() {
            return this.plotters;
        }

        public void setPlotters(TrendPlotter.Descriptor[] plotters) {
            this.plotters = plotters;
        }

        public TrendPlotter.Descriptor getPlotters(int index) {
            return this.plotters[index];
        }

        public void setPlotters(int index, TrendPlotter.Descriptor plotters) {
            this.plotters[index] = plotters;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public DataPanelDescriptor getPanel() {
            return this.panel;
        }

        public void setPanel(DataPanelDescriptor panel) {
            this.panel = panel;
        }

        @Override
        public Descriptor clone() {
            Descriptor clone = (Descriptor)super.clone();
            if (this.plotters != null) {
                int n = this.plotters.length;
                clone.plotters = new TrendPlotter.Descriptor[n];
                for (int i = 0; i < n; ++i) {
                    TrendPlotter.Descriptor tpDesc = this.plotters[i];
                    if (tpDesc == null) continue;
                    clone.plotters[i] = tpDesc.clone();
                }
            }
            if (this.panel != null) {
                clone.panel = this.panel.clone();
            }
            return clone;
        }
    }
}

