/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.DatabaseManagerSwing;

public class FontDialogSwing
extends JDialog {
    private static boolean isRunning = false;
    private static final String BACKGROUND = "Background";
    private static String defaultFont = "Dialog";
    private static final String FOREGROUND = "Foreground";
    private static JButton bgColorButton;
    private static JCheckBox ckbbold;
    private static JButton closeButton;
    private static JButton fgColorButton;
    private static JComboBox fontsComboBox;
    private static JComboBox fontSizesComboBox;
    private static final String[] fontSizes;
    private static DatabaseManagerSwing fOwner;
    private static JFrame frame;
    private static JCheckBox ckbitalic;

    public static void creatFontDialog(DatabaseManagerSwing databaseManagerSwing) {
        if (isRunning) {
            frame.setVisible(true);
        } else {
            CommonSwing.setSwingLAF(frame, CommonSwing.Native);
            fOwner = databaseManagerSwing;
            frame.setIconImage(CommonSwing.getIcon("Frame"));
            isRunning = true;
            frame.setSize(600, 100);
            CommonSwing.setFramePositon(frame);
            ckbitalic = new JCheckBox(new ImageIcon(CommonSwing.getIcon("ItalicFont")));
            ckbitalic.putClientProperty("is3DEnabled", Boolean.TRUE);
            ckbitalic.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontDialogSwing.setStyle();
                }
            });
            ckbbold = new JCheckBox(new ImageIcon(CommonSwing.getIcon("BoldFont")));
            ckbbold.putClientProperty("is3DEnabled", Boolean.TRUE);
            ckbbold.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontDialogSwing.setStyle();
                }
            });
            fgColorButton = new JButton(FOREGROUND, new ImageIcon(CommonSwing.getIcon("ColorSelection")));
            fgColorButton.putClientProperty("is3DEnabled", Boolean.TRUE);
            fgColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontDialogSwing.setColor(FontDialogSwing.FOREGROUND);
                }
            });
            bgColorButton = new JButton(BACKGROUND, new ImageIcon(CommonSwing.getIcon("ColorSelection")));
            bgColorButton.putClientProperty("is3DEnabled", Boolean.TRUE);
            bgColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontDialogSwing.setColor(FontDialogSwing.BACKGROUND);
                }
            });
            closeButton = new JButton("Close", new ImageIcon(CommonSwing.getIcon("Close")));
            closeButton.putClientProperty("is3DEnabled", Boolean.TRUE);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    frame.setVisible(false);
                }
            });
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
            Dimension dimension = new Dimension(160, 25);
            fontsComboBox = new JComboBox<String>(stringArray);
            fontsComboBox.putClientProperty("is3DEnabled", Boolean.TRUE);
            fontsComboBox.setMaximumSize(dimension);
            fontsComboBox.setPreferredSize(dimension);
            fontsComboBox.setMaximumSize(dimension);
            fontsComboBox.setEditable(false);
            fontsComboBox.setSelectedItem(defaultFont);
            fontsComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontDialogSwing.setFont();
                }
            });
            fontSizesComboBox = new JComboBox<String>(fontSizes);
            Dimension dimension2 = new Dimension(45, 25);
            fontSizesComboBox.putClientProperty("is3DEnabled", Boolean.TRUE);
            fontSizesComboBox.setMinimumSize(dimension2);
            fontSizesComboBox.setPreferredSize(dimension2);
            fontSizesComboBox.setMaximumSize(dimension2);
            fontSizesComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        FontDialogSwing.setFontSize((String)itemEvent.getItem());
                    }
                }
            });
            Container container = frame.getContentPane();
            container.setLayout(new FlowLayout());
            container.add(fontsComboBox);
            container.add(fontSizesComboBox);
            container.add(ckbbold);
            container.add(ckbitalic);
            container.add(fgColorButton);
            container.add(bgColorButton);
            container.add(closeButton);
            frame.pack();
            frame.setVisible(false);
        }
    }

    public static void setFont() {
        Font font = FontDialogSwing.fOwner.txtResult.getFont();
        FontDialogSwing.fOwner.txtResult.setFont(new Font(fontsComboBox.getSelectedItem().toString(), font.getStyle(), font.getSize()));
        Font font2 = FontDialogSwing.fOwner.txtResult.getFont();
        FontDialogSwing.fOwner.txtCommand.setFont(new Font(fontsComboBox.getSelectedItem().toString(), font2.getStyle(), font2.getSize()));
        Font font3 = FontDialogSwing.fOwner.txtResult.getFont();
        FontDialogSwing.fOwner.tTree.setFont(new Font(fontsComboBox.getSelectedItem().toString(), font3.getStyle(), font3.getSize()));
    }

    public static void setFontSize(String string) {
        Float f = new Float(string);
        float f2 = f.floatValue();
        Font font = FontDialogSwing.fOwner.tTree.getFont().deriveFont(f2);
        FontDialogSwing.fOwner.tTree.setFont(font);
        Font font2 = FontDialogSwing.fOwner.txtCommand.getFont().deriveFont(f2);
        FontDialogSwing.fOwner.txtCommand.setFont(font2);
        Font font3 = FontDialogSwing.fOwner.txtResult.getFont().deriveFont(f2);
        FontDialogSwing.fOwner.txtResult.setFont(font3);
    }

    public static void setStyle() {
        int n = 0;
        if (ckbbold.isSelected()) {
            n |= 1;
        }
        if (ckbitalic.isSelected()) {
            n |= 2;
        }
        FontDialogSwing.fOwner.tTree.setFont(FontDialogSwing.fOwner.txtCommand.getFont().deriveFont(n));
        FontDialogSwing.fOwner.txtCommand.setFont(FontDialogSwing.fOwner.txtCommand.getFont().deriveFont(n));
        FontDialogSwing.fOwner.txtResult.setFont(FontDialogSwing.fOwner.txtResult.getFont().deriveFont(n));
    }

    public static void setColor(String string) {
        if (string.equals(BACKGROUND)) {
            Color color = JColorChooser.showDialog(null, "DataBaseManagerSwing Choose Background Color", FontDialogSwing.fOwner.txtResult.getBackground());
            if (color != null) {
                bgColorButton.setBackground(color);
                FontDialogSwing.fOwner.txtCommand.setBackground(color);
                FontDialogSwing.fOwner.txtResult.setBackground(color);
            }
        } else {
            Color color = JColorChooser.showDialog(null, "DataBaseManagerSwing Choose Foreground Color", FontDialogSwing.fOwner.txtResult.getForeground());
            if (color != null) {
                fgColorButton.setBackground(color);
                FontDialogSwing.fOwner.txtCommand.setForeground(color);
                FontDialogSwing.fOwner.txtResult.setForeground(color);
            }
        }
    }

    static {
        fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "24", "36"};
        frame = new JFrame("DataBaseManagerSwing Font Selection Dialog");
    }
}

