/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;

public class UiUtilities {
    private final ActionHandler handler;

    public UiUtilities(ActionHandler handler) {
        this.handler = handler;
    }

    public static JLabel newLabel(String text, int width) {
        return UiUtilities.newLabel(text, width, UiConstants.FONT);
    }

    public static JLabel newLabel(String text, int width, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        Dimension d = label.getPreferredSize();
        if (width > 0) {
            d.width = width;
        }
        if (width >= 0) {
            label.setPreferredSize(d);
            label.setMinimumSize(d);
        }
        return label;
    }

    public JRadioButton newRadioButton(String title, String name) {
        return this.newRadioButton(title, name, UiConstants.FONT);
    }

    public JRadioButton newRadioButton(String title, String name, Font font) {
        JRadioButton rb = new JRadioButton(title);
        rb.setFont(font);
        Dimension d = rb.getPreferredSize();
        d.height = UiUtilities.getLabelSize((String)"X", (Font)font).height;
        rb.setPreferredSize(d);
        rb.setMinimumSize(d);
        rb.setFocusable(false);
        rb.setName(name);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UiUtilities.this.handler.handleRadioButton(((JRadioButton)evt.getSource()).getName());
            }
        });
        return rb;
    }

    public JButton newButton(String title, String name) {
        return this.newButton(title, name, false, null, UiConstants.FONT);
    }

    public JButton newButton(String title, String name, boolean small) {
        return this.newButton(title, name, small, null, UiConstants.FONT);
    }

    public JButton newButton(String title, String name, Font font) {
        return this.newButton(title, name, false, null, font);
    }

    public JButton newButton(String title, String name, boolean small, Font font) {
        return this.newButton(title, name, small, null, font);
    }

    public JButton newButton(String title, String name, boolean small, Font lblFont, Font font) {
        JButton btn = new JButton(title);
        btn.setFont(font);
        Dimension d = btn.getPreferredSize();
        if (small) {
            d.height = UiUtilities.getLabelSize((String)"X", (Font)(lblFont == null ? font : lblFont)).height;
        }
        btn.setPreferredSize(d);
        btn.setMinimumSize(d);
        btn.setFocusable(false);
        btn.setName(name);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UiUtilities.this.handler.handleButton(((JButton)evt.getSource()).getName());
            }
        });
        return btn;
    }

    public JTextField newTextField(String text, String name) {
        return this.newTextField(text, name, false, null, null);
    }

    public JTextField newTextField(String text, String name, Font font) {
        return this.newTextField(text, name, false, null, font);
    }

    public JTextField newTextField(String text, String name, boolean small) {
        return this.newTextField(text, name, small, null, null);
    }

    public JTextField newTextField(String text, String name, boolean small, Font lblFont) {
        return this.newTextField(text, name, small, lblFont, null);
    }

    public JTextField newTextField(String text, String name, boolean small, Font lblFont, Font font) {
        JTextField tf = new JTextField(text);
        if (font != null) {
            tf.setFont(font);
        }
        Dimension d = tf.getPreferredSize();
        if (small) {
            d.height = Math.min(d.height, (int)(1.5 * (double)UiUtilities.getLabelSize((String)"X", (Font)(lblFont == null ? UiConstants.FONT : lblFont)).height));
        }
        tf.setPreferredSize(d);
        tf.setMinimumSize(d);
        tf.setHorizontalAlignment(0);
        tf.setName(name);
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextField tf = (JTextField)evt.getSource();
                UiUtilities.this.handler.handleTextField(tf.getName(), tf.getText());
            }
        });
        return tf;
    }

    public TextFieldX newTextFieldX(String text, String name, int type) {
        return this.newTextFieldX(text, name, type, false, null, null);
    }

    public TextFieldX newTextFieldX(String text, String name, int type, Font font) {
        return this.newTextFieldX(text, name, type, false, null, font);
    }

    public TextFieldX newTextFieldX(String text, String name, int type, boolean small) {
        return this.newTextFieldX(text, name, type, small, null, null);
    }

    public TextFieldX newTextFieldX(String text, String name, int type, boolean small, Font lblFont) {
        return this.newTextFieldX(text, name, type, small, lblFont, null);
    }

    public TextFieldX newTextFieldX(String text, String name, int type, boolean small, Font lblFont, Font font) {
        TextFieldX tf = new TextFieldX(text, type);
        if (font != null) {
            tf.setFont(font);
        }
        Dimension d = tf.getPreferredSize();
        if (small) {
            d.height = Math.min(d.height, (int)(1.5 * (double)UiUtilities.getLabelSize((String)"X", (Font)(lblFont == null ? UiConstants.FONT : lblFont)).height));
        }
        tf.setPreferredSize(d);
        tf.setMinimumSize(d);
        tf.setHorizontalAlignment(0);
        tf.setName(name);
        tf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ((TextFieldX)evt.getSource()).focusLost();
            }
        });
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextFieldX tf = (TextFieldX)evt.getSource();
                Object value = tf.action();
                if (value != null) {
                    UiUtilities.this.handler.handleTextFieldX(tf.getName(), value);
                }
            }
        });
        tf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ((TextFieldX)evt.getSource()).keyTyped(evt.getKeyChar());
            }
        });
        return tf;
    }

    public JCheckBox newCheckBox(String title, String name) {
        return this.newCheckBox(title, name, UiConstants.FONT);
    }

    public JCheckBox newCheckBox(String title, String name, Font font) {
        JCheckBox cbx = new JCheckBox(title);
        cbx.setFont(font);
        cbx.setFocusable(false);
        cbx.setName(name);
        cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCheckBox cbx = (JCheckBox)evt.getSource();
                UiUtilities.this.handler.handleCheckBox(cbx.getName(), cbx.isSelected());
            }
        });
        return cbx;
    }

    public static JPanel newBorderedPanel(String title) {
        return UiUtilities.newBorderedPanel(title, UiConstants.FONT);
    }

    public static JPanel newBorderedPanel(String title, Font font) {
        JPanel panel = new JPanel();
        AbstractBorder border = new LineBorder(Color.BLACK);
        if (title != null) {
            TitledBorder tBorder = new TitledBorder(border, title);
            tBorder.setTitleJustification(2);
            tBorder.setTitleFont(font);
            tBorder.setTitleColor(UiConstants.BLUE);
            border = tBorder;
        }
        panel.setBorder(border);
        panel.setLayout(new GridBagLayout());
        return panel;
    }

    public static int maxLabelWidth(String[] text, String term) {
        return UiUtilities.maxLabelWidth(text, term, UiConstants.FONT);
    }

    public static int maxLabelWidth(String[] text, String term, Font font) {
        JLabel label = new JLabel();
        label.setFont(font);
        int width = 0;
        for (String item : text) {
            label.setText(item + term);
            width = Math.max(width, label.getPreferredSize().width);
        }
        return width;
    }

    public static int maxEnumLabelWidth(Class enumClass) {
        return UiUtilities.maxEnumLabelWidth(enumClass, UiConstants.FONT);
    }

    public static int maxEnumLabelWidth(Class enumClass, Font font) {
        JLabel label = new JLabel();
        label.setFont(font);
        int width = 0;
        for (Object en : enumClass.getEnumConstants()) {
            label.setText(en.toString());
            width = Math.max(width, label.getPreferredSize().width);
        }
        return width;
    }

    public static Dimension getLabelSize(String text) {
        return UiUtilities.getLabelSize(text, UiConstants.FONT);
    }

    public static Dimension getLabelSize(String text, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        return label.getPreferredSize();
    }

    public static interface ActionHandler {
        default public void handleButton(String name) {
        }

        default public void handleRadioButton(String name) {
        }

        default public void handleTextField(String name, String text) {
        }

        default public void handleTextFieldX(String name, Object value) {
        }

        default public void handleCheckBox(String name, boolean isSelected) {
        }
    }
}

