package org.lsst.ccs.subsystem.common.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

/**
 *  Implements the system status line sub-panel.
 *
 *  This needs to be incorporated into a "top-level" panel
 *
 *  @author Owen Saxton
 */
public class SystemStatusPanel extends JPanel implements UiUtilities.ActionHandler {

    private static final int statusWidth = UiUtilities.maxLabelWidth(new String[]{"STOPPED", "RUNNING"}, "");

    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private JLabel stateLabel;
    private JLabel stateStatus;
    private JLabel periodLabel;
    private TextFieldX periodTextField;
    private JLabel periodUnitsLabel;

    public SystemStatusPanel(CommandSender cons) {
        this.sender = cons;
        uiUtils = new UiUtilities(this);
        initComponents();
        disableSystem();
    }

    public void updateStatus(int tickMillis) {
        stateStatus.setText("RUNNING");
        stateStatus.setForeground(UiConstants.GREEN);
        periodTextField.update(tickMillis / 1000.0, true);
    }

    public void disableSystem() {
        stateStatus.setText("STOPPED");
        stateStatus.setForeground(UiConstants.RED);
        periodTextField.setDisabled();
    }

    private void initComponents() {
        stateLabel = UiUtilities.newLabel("System State: ", 0);
        stateStatus = UiUtilities.newLabel("XXX", statusWidth);
        periodLabel = UiUtilities.newLabel("Update Period: ", 0);
        periodTextField = uiUtils.newTextFieldX("99999.9", "", TextFieldX.TYPE_DOUBLE);
        periodUnitsLabel = UiUtilities.newLabel("sec", 0);

        setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 5, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = GridBagConstraints.NORTHWEST;
        add(stateLabel, gbh);
        gbh.gridx++;
        add(stateStatus, gbh);
        gbh.gridx++;
        gbh.insets.left = 72;
        add(periodLabel, gbh);
        gbh.gridx++;
        gbh.insets.left = 5;
        gbh.insets.top -= 2;
        add(periodTextField, gbh);
        gbh.gridx++;
        gbh.insets.top += 2;
        add(periodUnitsLabel, gbh);
    }

    @Override
    public void handleTextFieldX(String name, Object value) {
        sender.sendCommand(null, "setUpdatePeriod", (int)(1000 * (Double)value));
    }

    private static final long serialVersionUID = 1L;
}
