/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer;

import hep.aida.IFunction;
import hep.aida.ext.IDomainConstraint;
import hep.aida.ext.IOptimizer;
import hep.aida.ext.IOptimizerConfiguration;
import hep.aida.ext.IOptimizerResult;
import hep.aida.ext.IVariableSettings;
import hep.aida.ref.optimizer.OptimizerResult;
import hep.aida.ref.optimizer.VariableSettings;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractOptimizer
implements IOptimizer {
    protected IFunction function = null;
    protected OptimizerResult result;
    protected IOptimizerConfiguration configuration;
    protected IDomainConstraint domainConstraint;
    private Hashtable varSetHash = new Hashtable();

    @Override
    public IOptimizerConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public abstract void optimize();

    @Override
    public void reset() {
        this.function = null;
    }

    @Override
    public IOptimizerResult result() {
        return this.result;
    }

    @Override
    public void setConfiguration(IOptimizerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setConstraints(IDomainConstraint iDomainConstraint) {
        this.domainConstraint = iDomainConstraint;
    }

    @Override
    public void setFunction(IFunction iFunction) {
        this.function = iFunction;
        String[] varNames = this.function.variableNames();
        for (int i = 0; i < varNames.length; ++i) {
            this.variableSettings(varNames[i]);
        }
    }

    @Override
    public String[] listVariableSettings() {
        int size = this.varSetHash.size();
        String[] varNames = new String[size];
        Enumeration e = this.varSetHash.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            varNames[i] = (String)e.nextElement();
            ++i;
        }
        return varNames;
    }

    @Override
    public void resetVariableSettings() {
        this.varSetHash.clear();
    }

    @Override
    public IVariableSettings variableSettings(String name) {
        if (this.varSetHash.containsKey(name)) {
            return (IVariableSettings)this.varSetHash.get(name);
        }
        VariableSettings varSet = new VariableSettings(name);
        this.varSetHash.put(name, varSet);
        return varSet;
    }

    @Override
    public boolean acceptsConstraints() {
        return false;
    }

    @Override
    public boolean canCalculateContours() {
        return false;
    }

    @Override
    public double[][] calculateContour(String par1, String par2, int npts, double nSigmas) {
        throw new UnsupportedOperationException();
    }
}

