/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;

public class AgentStatusEvent
extends EventObject {
    private final AgentStatusAggregator aggregator;
    private final StatusMessage message;
    protected final Map<AgentChannel, List<String>> statusChanges;
    protected final List<AgentChannel> addedChannels;
    protected final List<AgentChannel> removedChannels;

    AgentStatusEvent(AgentStatusAggregator aggregator, StatusMessage message, Map<AgentChannel, List<String>> statusChanges, List<AgentChannel> addedChannels, List<AgentChannel> removedChannels) {
        super(message.getOriginAgentInfo());
        this.aggregator = aggregator;
        this.message = message;
        this.statusChanges = statusChanges;
        this.addedChannels = addedChannels;
        this.removedChannels = removedChannels;
    }

    AgentStatusEvent(AgentStatusAggregator aggregator, AgentInfo agent, Map<AgentChannel, List<String>> statusChanges, List<AgentChannel> addedChannels, List<AgentChannel> removedChannels) {
        super(agent);
        this.aggregator = aggregator;
        this.message = null;
        this.statusChanges = statusChanges == null ? Collections.emptyMap() : statusChanges;
        this.addedChannels = addedChannels == null ? Collections.emptyList() : addedChannels;
        this.removedChannels = removedChannels == null ? Collections.emptyList() : removedChannels;
    }

    AgentStatusEvent(AgentStatusAggregator aggregator, AgentInfo agent) {
        super(agent);
        this.aggregator = aggregator;
        this.message = null;
        this.statusChanges = Collections.emptyMap();
        this.addedChannels = Collections.emptyList();
        this.removedChannels = Collections.emptyList();
    }

    public AgentInfo getSource() {
        return (AgentInfo)this.source;
    }

    public StatusMessage getMessage() {
        return this.message;
    }

    public AgentStatusAggregator getAggregator() {
        return this.aggregator;
    }

    public Map<AgentChannel, List<String>> getStatusChanges() {
        return this.statusChanges;
    }

    public List<AgentChannel> getAddedChannels() {
        return this.addedChannels;
    }

    public List<AgentChannel> getRemovedChannels() {
        return this.removedChannels;
    }

    public boolean isEmpty() {
        return this.statusChanges.isEmpty() && this.addedChannels.isEmpty() && this.removedChannels.isEmpty();
    }

    public AgentStatusEvent filter(Set<String> innerPaths) {
        List<AgentChannel> removed;
        Map<AgentChannel, List<String>> changes = innerPaths == null ? Collections.emptyMap() : this.statusChanges.entrySet().stream().filter((? super T e) -> innerPaths.contains(((AgentChannel)e.getKey()).getLocalPath())).collect(Collectors.toMap(e -> (AgentChannel)e.getKey(), e -> (List)e.getValue()));
        List<AgentChannel> added = innerPaths == null ? Collections.emptyList() : this.addedChannels.stream().filter((? super T c) -> innerPaths.contains(c.getLocalPath())).collect(Collectors.toList());
        List<AgentChannel> list = removed = innerPaths == null ? Collections.emptyList() : this.removedChannels.stream().filter((? super T c) -> innerPaths.contains(c.getLocalPath())).collect(Collectors.toList());
        if (this.message == null) {
            return new AgentStatusEvent(this.aggregator, this.getSource(), changes, added, removed);
        }
        return new AgentStatusEvent(this.aggregator, this.message, changes, added, removed);
    }

    public AgentStatusEvent filter(AgentChannelsFilter filter) {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Event from ");
        sb.append(this.getSource().getName()).append(":");
        sb.append(" added ").append(this.addedChannels.size()).append(" channels, removed ");
        sb.append(this.removedChannels.size()).append(" channels, modified ");
        sb.append(this.statusChanges.size()).append(" channels.");
        return sb.toString();
    }
}

