package org.lsst.ccs.subsystem.common.ui;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.data.BasicState;

/**
 *  Implements a minimal control panel.
 *
 *  @author Owen Saxton
 */
public class BasicControlPanel extends JPanel {

    private final CommandSender sender;
    private SystemStatusPanel statusPanel;

    public BasicControlPanel(CommandSender sender) {
        this.sender = sender;
        initComponents();
        (new DisableSystem()).run();
    }

    private void initComponents()
    {
        // Status line panel
        statusPanel = new SystemStatusPanel(sender);
        
        // Whole panel
        add(statusPanel);
    }

    public void updateControlPanel(BasicState state) {
        SwingUtilities.invokeLater(new UpdateControlPanel(state));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    class UpdateControlPanel implements Runnable {

        private final BasicState state;

        UpdateControlPanel(BasicState state) {
            this.state = state;
        }

        @Override
        public void run() {
            statusPanel.updateStatus(state.getTickMillis());
            repaint();
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            statusPanel.disableSystem();
            repaint();
        } 
    }

    private static final long serialVersionUID = 1L;
}
