/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Channel
implements HasLifecycle {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_TEMP = 0;
    public static final int TYPE_VOLTS = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_SWITCH = 3;
    public static final int TYPE_SUM = 4;
    public static final int TYPE_DIFF = 5;
    public static final int TYPE_PROD = 6;
    public static final int TYPE_QUOT = 7;
    private static final int LIMIT_CHECK_NONE = 0;
    private static final int LIMIT_CHECK_FLAG = 1;
    private static final int LIMIT_CHECK_ALARM = 2;
    private final String DEFAULT_FORMAT = "%.2f ";
    private static final Map<String, Integer> checkMap = new HashMap<String, Integer>();
    protected String description = "";
    protected String units = "";
    protected String devcName;
    protected int hwChan = 0;
    protected String type = "";
    protected String subtype = "";
    protected double offset = 0.0;
    protected double scale = 1.0;
    protected String checkLo = "FLAG";
    protected String alarmLo;
    @ConfigurationParameter(name="dbandLo", category="Limits")
    protected double dbandLo = 0.0;
    protected String checkHi = "FLAG";
    protected String alarmHi;
    @ConfigurationParameter(name="dbandHi", category="Limits")
    protected double dbandHi = 0.0;
    protected int pageId = 0;
    protected String format = "%.2f ";
    @ConfigurationParameter(name="limitLo", category="Limits")
    protected double limitLo = 0.0;
    @ConfigurationParameter(name="limitHi", category="Limits")
    protected double limitHi = 0.0;
    @LookupName
    private String name;
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Device devc;
    protected int typeI;
    private int subtypeI;
    private int checkLoI;
    private Alarm alarmLoA;
    private int checkHiI;
    private Alarm alarmHiA;
    private int id;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor mon;
    private double value;
    private CCSTimeStamp ccsTimeStamp;
    private DataProviderState state = DataProviderState.OFF_LINE;
    protected double resetLo = 0.0;
    protected double resetHi = 0.0;
    private boolean ignrAlarmLo;
    private boolean ignrAlarmHi;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;

    public final void setFormat(String fmt) {
        this.format = fmt == null || fmt.isEmpty() ? "%.2f " : (fmt.charAt(0) != '%' ? "%" + fmt : fmt) + " ";
    }

    @Override
    public void init() {
        this.configure(this.mon, this.mon.getChannelId(this));
    }

    @ConfigurationParameterChanger
    public void setLimitLo(double limit) {
        if (limit == this.limitLo) {
            return;
        }
        this.limitLo = limit;
        this.setResetLo();
    }

    @ConfigurationParameterChanger
    public void setLimitHi(double limit) {
        if (limit == this.limitHi) {
            return;
        }
        this.limitHi = limit;
        this.setResetHi();
    }

    @ConfigurationParameterChanger
    public void setDbandLo(double value) {
        this.dbandLo = value;
        this.setResetLo();
    }

    @ConfigurationParameterChanger
    public void setDbandHi(double value) {
        this.dbandHi = value;
        this.setResetHi();
    }

    private void setResetLo() {
        this.resetLo = this.dbandLo <= 0.0 ? this.limitLo : this.limitLo + this.dbandLo;
    }

    private void setResetHi() {
        this.resetHi = this.dbandHi <= 0.0 ? this.limitHi : this.limitHi - this.dbandHi;
    }

    void configure(Monitor mon, int id) {
        this.id = id;
        this.checkLoI = 1;
        this.checkHiI = 1;
        this.typeI = -1;
        this.subtypeI = -1;
        try {
            if (this.devcName == null && this.devc == null) {
                MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "device name");
            }
            if (this.devc == null) {
                this.devc = mon.getDevice(this.devcName);
            }
            if (this.devc == null) {
                MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "device name", this.devcName);
                throw new RuntimeException("Device " + this.devcName + " does not exist. We cannot proceed. Please fix the problem.");
            }
            String origFmt = this.format;
            origFmt = origFmt == null || origFmt.isEmpty() ? "%.2f " : (origFmt.charAt(0) != '%' ? "%" + origFmt : origFmt) + " ";
            try {
                String string = String.format(origFmt, 0.0);
            }
            catch (IllegalFormatException e) {
                origFmt = "%.2f ";
                MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "display format", origFmt);
            }
            this.format = origFmt;
            Integer iCheck = checkMap.get(this.checkLo.toUpperCase());
            if (iCheck == null) {
                MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "low check option", this.checkLo);
            }
            this.checkLoI = iCheck;
            iCheck = checkMap.get(this.checkHi.toUpperCase());
            if (iCheck == null) {
                MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "high check option", this.checkHi);
            }
            this.checkHiI = iCheck;
            if (this.alarmLo != null) {
                this.alarmLoA = mon.getAlarm(this.alarmLo);
            }
            if (this.alarmLoA == null && (this.checkLoI == 2 || this.alarmLo != null)) {
                MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "low alarm name", this.alarmLo);
            }
            if (this.alarmHi != null) {
                this.alarmHiA = mon.getAlarm(this.alarmHi);
            }
            if (this.alarmHiA == null && (this.checkHiI == 2 || this.alarmHi != null)) {
                MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "high alarm name", this.alarmHi);
            }
            int[] types = this.devc.checkChannel(this.name, this.hwChan, this.type, this.subtype);
            this.typeI = types[0];
            this.subtypeI = types[1];
            this.devc.addChannel(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initSensor() {
        if (this.state == DataProviderState.DISABLED) {
            return;
        }
        this.devc.initChannel(this.name, this.id, this.hwChan, this.typeI, this.subtypeI);
    }

    double readSensor() {
        double val = this.state == DataProviderState.DISABLED || !this.devc.isOnline() ? Double.NaN : this.devc.readChannel(this);
        double tmpVal = val;
        this.ccsTimeStamp = CCSTimeStamp.currentTime();
        if (!Double.isNaN(val)) {
            tmpVal = this.convertRawValue(val);
            this.state = DataProviderState.NOMINAL;
        } else {
            this.state = DataProviderState.OFF_LINE;
        }
        this.value = tmpVal;
        return this.value;
    }

    public double convertRawValue(double rawValue) {
        return this.offset + this.scale * rawValue;
    }

    void checkLimits() {
        if (this.state == DataProviderState.DISABLED || this.state == DataProviderState.OFF_LINE) {
            return;
        }
        this.state = DataProviderState.NOMINAL;
        DataProviderState lostate = DataProviderState.NOMINAL;
        DataProviderState histate = DataProviderState.NOMINAL;
        String loCause = null;
        String hiCause = null;
        String overallCause = null;
        if (this.checkLoI != 0) {
            if (this.value < this.limitLo) {
                lostate = DataProviderState.ALARM;
            } else if (this.value < this.resetLo) {
                lostate = DataProviderState.WARNING;
            }
            switch (lostate) {
                case WARNING: {
                    loCause = "WARNING: Channel " + this.getPath() + " value " + this.value + " in low warning band (" + this.limitLo + "," + this.resetLo + ")";
                    break;
                }
                case ALARM: {
                    loCause = "ALARM: Channel " + this.getPath() + " value " + this.value + " below low limit " + this.limitLo;
                    break;
                }
                case NOMINAL: {
                    loCause = "NOMINAL: Channel " + this.getPath() + " value " + this.value + " above warning limit " + this.resetLo;
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal state " + lostate);
                }
            }
            if (lostate.ordinal() >= this.state.ordinal()) {
                this.state = lostate;
                overallCause = loCause;
            }
        }
        if (this.checkHiI != 0) {
            if (this.value > this.limitHi) {
                histate = DataProviderState.ALARM;
            } else if (this.value > this.resetHi) {
                histate = DataProviderState.WARNING;
            }
            switch (histate) {
                case WARNING: {
                    hiCause = "WARNING: Channel " + this.getPath() + " value " + this.value + " in high warning band (" + this.resetHi + "," + this.limitHi + ")";
                    break;
                }
                case ALARM: {
                    hiCause = "ALARM: Channel " + this.getPath() + " value " + this.value + " above high limit " + this.limitHi;
                    break;
                }
                case NOMINAL: {
                    hiCause = "NOMINAL: Channel " + this.getPath() + " value " + this.value + " below warning high " + this.resetHi;
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal state " + histate);
                }
            }
            if (histate.ordinal() >= this.state.ordinal()) {
                this.state = histate;
                overallCause = hiCause;
            }
        }
        if (this.alarmLoA == this.alarmHiA) {
            if (this.checkLoI == 2 && !this.ignrAlarmLo || this.checkHiI == 2 && !this.ignrAlarmHi) {
                if (this.state == DataProviderState.NOMINAL) {
                    overallCause = "NOMINAL: Channel " + this.getPath() + " value " + this.value + " in nominal range (" + this.resetLo + "," + this.resetHi + ")";
                }
                this.alarmLoA.updateState(this, this.state, overallCause);
            }
        } else {
            if (this.checkLoI == 2 && !this.ignrAlarmLo) {
                this.alarmLoA.updateState(this, lostate, loCause);
            }
            if (this.checkHiI == 2 && !this.ignrAlarmHi) {
                this.alarmHiA.updateState(this, histate, hiCause);
            }
        }
    }

    public Device getDevice() {
        return this.devc;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String getUnits() {
        return this.units;
    }

    public int getPageId() {
        return this.pageId;
    }

    public double getLimitLo() {
        return this.limitLo;
    }

    public String getAlarmNameLo() {
        return this.checkLoI == 2 ? this.alarmLo : (this.checkLoI == 1 ? "" : null);
    }

    public double getLimitHi() {
        return this.limitHi;
    }

    public double getDbandLo() {
        return this.dbandLo;
    }

    public double getDbandHi() {
        return this.dbandHi;
    }

    public String getAlarmNameHi() {
        return this.checkHiI == 2 ? this.alarmHi : (this.checkHiI == 1 ? "" : null);
    }

    int getId() {
        return this.id;
    }

    public void enableAlarm(boolean isLow, boolean enable) {
        if (isLow) {
            this.ignrAlarmLo = !enable;
        } else {
            this.ignrAlarmHi = !enable;
        }
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public double getValue() {
        return this.value;
    }

    public double readValue() {
        this.readSensor();
        return this.getValue();
    }

    CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    DataProviderState getState() {
        return this.state;
    }

    public void setValid(boolean isValid) {
        this.state = !isValid ? DataProviderState.DISABLED : DataProviderState.NOMINAL;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    static {
        checkMap.put("NONE", 0);
        checkMap.put("FLAG", 1);
        checkMap.put("ALARM", 2);
    }
}

