package org.lsst.ccs.subsystem.commons.ui.jas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.base.filter.GenericFilterPersistable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Generic monitoring filter.
 *
 * @author The LSST CCS Team
 */
public class MonitorFilter extends GenericFilterPersistable {

    private static final List<String> FIELDS = new ArrayList<>();
    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
    }

    public MonitorFilter(List<String> agents) {
        super("MyName", agents, Collections.singletonList("/main/"), "", true, FIELDS);
    }

    @Override
    public String getDisplayPath(AgentChannel channel) {
        String path = channel.getLocalPath();
        String section = channel.get(AgentChannel.Key.SECTION);
        if ( null == section || section.isEmpty() ) {
            section = "Common";
        }
        int i1 = path.lastIndexOf("/");
        int i2 = path.indexOf(".", i1+1);
        String newPath;
        if (i1 != -1 && i2 != -1) {
            newPath = path.substring(i1 + 1, i2)+"//"+section+"//"+ path.substring(i2 + 1);
        } else {
            if ( i1 != -1 ) {
                newPath = section+"//"+path.substring(i1+1);
            } else if (i2 != -1) {
                newPath = section+"//"+path.substring(i2+1);                
            } else {
                newPath = section+"//"+path;
            }
        }        
        return newPath;
    }

}
