/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.concurrent.CancellationException;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class SaveDescriptorDialog
extends JDialog {
    private Persistable.Descriptor descriptor;
    private final JTextField pathField;
    private final JTextField nameField;
    private final JEditorPane descriptionPane;
    private final JButton okButton;
    private final Pattern pathPattern = Pattern.compile("\\A[a-zA-Z][a-zA-Z_0-9 \\-/]*\\z");

    private SaveDescriptorDialog(Persistable.Descriptor desc, String title, Component parent) {
        super(parent == null ? Console.getConsole().getWindow() : SwingUtilities.getWindowAncestor(parent), title == null ? "Saving..." : title, Dialog.ModalityType.APPLICATION_MODAL);
        this.descriptor = desc;
        this.setLayout(new BorderLayout());
        Box top = Box.createVerticalBox();
        this.add((Component)top, "North");
        Box box = Box.createHorizontalBox();
        top.add(box);
        box.add(new JLabel("Path: "));
        box.add(Box.createRigidArea(Const.HDIM));
        this.pathField = new JTextField(50);
        box.add(this.pathField);
        if (this.descriptor.getPath() != null) {
            this.pathField.setText(this.descriptor.getPath());
        }
        this.pathField.addCaretListener(e -> this.validatePath());
        box.add(Box.createHorizontalGlue());
        box = Box.createHorizontalBox();
        top.add(box);
        box.add(new JLabel("Name: "));
        box.add(Box.createRigidArea(Const.HDIM));
        this.nameField = new JTextField(50);
        box.add(this.nameField);
        if (this.descriptor.getName() != null) {
            this.nameField.setText(this.descriptor.getName());
        }
        box.add(Box.createHorizontalGlue());
        JPanel center = new JPanel();
        this.add((Component)center, "Center");
        center.setBorder(BorderFactory.createTitledBorder("Description"));
        this.descriptionPane = new JEditorPane("text/plain", this.descriptor.getDescription());
        center.add(new JScrollPane(this.descriptionPane));
        this.descriptionPane.setEditable(true);
        this.descriptionPane.setPreferredSize(new Dimension(300, 200));
        Box buttonBox = Box.createHorizontalBox();
        this.add((Component)buttonBox, "South");
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttonBox.add(Box.createHorizontalGlue());
        JButton b = new JButton("Cancel");
        b.addActionListener(e -> {
            this.dispose();
            throw new CancellationException();
        });
        buttonBox.add(b);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(e -> {
            String s = this.pathField.getText().trim();
            if (!s.isEmpty()) {
                this.descriptor.setPath(s);
                s = this.nameField.getText().trim();
                this.descriptor.setName(s.isEmpty() ? null : s);
                s = this.descriptionPane.getText();
                this.descriptor.setDescription(s.isEmpty() ? null : s);
                this.dispose();
            }
        });
        this.validatePath();
        buttonBox.add(this.okButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
    }

    public static Persistable.Descriptor show(Persistable.Descriptor desc, String title, Component parent) {
        SaveDescriptorDialog dialog = new SaveDescriptorDialog(desc, title, parent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.descriptor;
    }

    private void validatePath() {
        String s = this.pathField.getText();
        this.okButton.setEnabled(this.pathPattern.matcher(s).matches());
    }
}

