package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduProperties;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;

/**
 *
 * @author The LSST CCS Team
 */
//@Plugin(name = "Apc Pdu plugin", description = "Displays Outlet states and monitoring channels for ApcPdu")
public class ApcPduPlugin extends ConsolePlugin {

    private final OptionalPage apcpduOptionalPage = new ApcPduPlugin.ApcPduOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().getOptionalPageService().add(apcpduOptionalPage);
    }

    static class ApcPduOptionalPage implements OptionalPage {

        private final Map<AgentInfo,List<String>> listOfPdus = new HashMap<>();
        
        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (!agent.getAgentProperty(PduProperties.HAS_PDU,"").isEmpty()) {
                String pdus = agent.getAgentProperty(PduProperties.PDU_COMPONENTS,"");
                listOfPdus.put(agent, new ArrayList<>(Arrays.asList( pdus.split(","))));
                return "CCS Subsystems/ApcPdu/"+agent.getName();
            }
            return null;
        }


        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setName(agent.getName()+" PDU");
            
            String monitorSelector = "";
            String stateSelector = "";
            for ( String pdu : listOfPdus.get(agent) ) {
                if ( !monitorSelector.isEmpty() ) {
                    monitorSelector += ",";
                }
                monitorSelector += "/"+pdu+"/";
                if ( !stateSelector.isEmpty() ) {
                    stateSelector += ",";
                }
                stateSelector += "/state/"+pdu+"/";
            }
            TabbedView monitorView = new TabbedView();
            monitorView.setViewFactory(name -> new SectionedTableView());
            ApcPduMonitorFilter filter = new ApcPduMonitorFilter(agent.getName(), monitorSelector);
            monitorView.setFilter(filter);
            monitorView.install();
            monitorView.getPanel().setName("Monitor");
            
            panel.add(monitorView.getPanel(),BorderLayout.NORTH);
            
            TabbedView stateView = new TabbedView();
            stateView.setViewFactory(name -> new SectionedTableView());
            ApcPduStateFilter stateFilter = new ApcPduStateFilter(agent.getName(), stateSelector);
            stateView.setFilter(stateFilter);
            stateView.install();
            stateView.getPanel().setName("State");
            
            panel.add(stateView.getPanel(),BorderLayout.SOUTH);
            
            return panel;
        }

    }
}
