/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas.MonitorFormatter;

@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter", name="Apc Pdu monitor", path="Components/ApcPdu", description="Apc Pdu monitoring channel filter.")
public class MonitorFilter
extends AbstractChannelsFilter {
    public static final MonitorFormat FORMAT = new MonitorFormatter();
    private static Pattern pPduOutlet = Pattern.compile("([^/]+)/state(/.+)/([^/]+)/PduOutletState");
    private final String agent;
    private final String[] pdus;

    public MonitorFilter(String agent, String pdus) {
        this.agent = agent;
        this.pdus = pdus.split(",");
    }

    public MonitorFilter(AgentInfo agent) {
        this.agent = agent.getName();
        this.pdus = agent.getAgentProperty("Pdu_Components", "").split(",");
    }

    public String getName() {
        return this.agent;
    }

    public List<String> getAgents() {
        return Collections.singletonList(this.agent);
    }

    public List<String> getOriginChannels() {
        ArrayList<String> selectors = new ArrayList<String>();
        for (String pdu : this.pdus) {
            selectors.add("/" + pdu + "/");
            selectors.add("/state/" + pdu + "/");
        }
        return selectors;
    }

    public String getOriginPath(String displayPath) {
        return super.getOriginPath(displayPath);
    }

    public List<String> getDisplayPath(String originPath) {
        String dp = originPath.replaceFirst(this.agent + "/", "");
        int i = (dp = dp.replaceFirst("state/", "")).indexOf("/PduOutletState");
        if (i != -1) {
            dp = dp.substring(0, i);
            i = dp.lastIndexOf("/");
            dp = dp.substring(0, i) + "/Outlets" + dp.substring(i);
        }
        return Collections.singletonList(dp);
    }

    public List<String> getFields(boolean compact) {
        if (compact) {
            return Arrays.asList(MonitorField.VALUE.getKey(), MonitorField.DESCR.getKey());
        }
        return Arrays.asList(MonitorField.VALUE.getKey(), MonitorField.UNITS.getKey(), MonitorField.LOW_ALARM.getKey(), MonitorField.LOW_WARN.getKey(), MonitorField.ALERT_LOW.getKey(), MonitorField.HIGH_WARN.getKey(), MonitorField.HIGH_ALARM.getKey(), MonitorField.ALERT_HIGH.getKey(), MonitorField.DESCR.getKey());
    }

    public static String[] getPduAndOutletName(String path) {
        Matcher m = pPduOutlet.matcher(path);
        if (m.matches()) {
            return new String[]{m.group(1) + m.group(2), m.group(3)};
        }
        return null;
    }
}

