package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.List;
import javax.swing.JOptionPane;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduOutletState;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;

/**
 * 
 *
 * @author onoprien
 */
public class MonitorFormatter extends MonitorFormat {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------


    @Override
    public FormattedValue format(FormattedValue fv) {
//        if (fv.value instanceof PduOutletState) {
        if ("ON".equals(fv.value) || "OFF".equals(fv.value)) {
            if (fv.bgColor == null) fv.bgColor = fv.value.equals("ON") ? COLOR_GOOD : COLOR_WARN;
            if (fv.toolTip == null) fv.toolTip = "Click to switch ON/OFF";
            fv.click1 = cell -> {
                if (cell != null) {
                    List<ChannelHandle> hh = cell.getChannels();
                    if (hh.size() == 1) {
                        AgentChannel channel = hh.get(0).getChannel();
                        if (channel != null) {
                            String[] ss = MonitorFilter.getPduAndOutletName(channel.getPath());
                            if (ss != null) {
                                String status = channel.get().toString();
                                boolean on = "ON".equals(status);
                                status = on ? "OFF" : "ON";
                                int flip = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>Switch the power outlet<br><b>"+ ss[1] +"</b> "+ status +"?", "Switch PDU outlet " + status, JOptionPane.OK_CANCEL_OPTION);
                                if (flip == JOptionPane.OK_OPTION) {
                                    Console.getConsole().sendCommand(ss[0] + (on ? "/outletOff" : "/forceOutletOn"), ss[1]);
                                }
                            }
                        }
                    }
                }
            };
        }
        return super.format(fv);
    }
    
    private String getOutletName(AgentChannel channel) {
        String path = channel.getLocalPath();
        int i = path.lastIndexOf("/PduOutletState");
        if (i == -1) return null;
        int ii = path.lastIndexOf("/", i-1);
        if (ii == -1) return null;
        return path.substring(ii+1, i);
    }

}
