package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduProperties;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;

/**
 * 
 *
 * @author onoprien
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Apc Pdu monitor",
               path="Components/ApcPdu",
               description="Apc Pdu monitoring channel filter.")
public class MonitorFilter extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final MonitorFormat FORMAT = new MonitorFormatter();
    
    static private Pattern pPduOutlet = Pattern.compile("([^/]+)/state(/.+)/([^/]+)/PduOutletState");
    
    private final String agent;
    private final String[] pdus;

// -- Life cycle : -------------------------------------------------------------
    
    public MonitorFilter(String agent, String pdus) {
        this.agent = agent;
        this.pdus = pdus.split(",");
    }
    
    public MonitorFilter(AgentInfo agent) {
        this.agent = agent.getName();
        this.pdus = agent.getAgentProperty(PduProperties.PDU_COMPONENTS,"").split(",");
    }

    
// -- Filtering : --------------------------------------------------------------
    
    @Override
    public String getName() {
        return agent;
    }

    @Override
    public List<String> getAgents() {
        return Collections.singletonList(agent);
    }

    @Override
    public List<String> getOriginChannels() {
        ArrayList<String> selectors = new ArrayList<>();
        for (String pdu : pdus) {
            selectors.add("/"+ pdu +"/");
            selectors.add("/state/"+ pdu +"/");
        }
        return selectors;
    }

    @Override
    public String getOriginPath(String displayPath) {
        return super.getOriginPath(displayPath);
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        String dp = originPath.replaceFirst(agent +"/", "");
        dp = dp.replaceFirst("state/", "");
        int i = dp.indexOf("/PduOutletState");
        if (i != -1) {
            dp = dp.substring(0, i);
            i = dp.lastIndexOf("/");
            dp = dp.substring(0,i)+"/Outlets"+dp.substring(i);
        }
        return Collections.singletonList(dp);
    }

    @Override
    public List<String> getFields(boolean compact) {
        if (compact) {
            return Arrays.asList(new String[] {MonitorField.VALUE.getKey(), MonitorField.DESCR.getKey()});
        } else {
            return Arrays.asList(new String[] {MonitorField.VALUE.getKey(), 
                MonitorField.UNITS.getKey(),
                MonitorField.LOW_ALARM.getKey(),
                MonitorField.LOW_WARN.getKey(),
                MonitorField.ALERT_LOW.getKey(),
                MonitorField.HIGH_WARN.getKey(),
                MonitorField.HIGH_ALARM.getKey(),
                MonitorField.ALERT_HIGH.getKey(),
                MonitorField.DESCR.getKey()});
        }
    }
    
    
// -- Utilities : --------------------------------------------------------------
    
    static public String[] getPduAndOutletName(String path) {
        Matcher m = pPduOutlet.matcher(path);
        if (m.matches()) {
            return new String[] {m.group(1) + m.group(2), m.group(3)};
        } else {
            return null;
        }
    }
    
}
