package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.filter.GenericFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Apc Pdu state channel filter.
 *
 * @author The LSST CCS Team
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Apc Pdu state filter",
               path="Subsystems/ApcPdu",
               description="Apc Pdu state filter.")
public class ApcPduStateFilter extends GenericFilter {


    public final static String FIELDS = 
        MonitorField.VALUE.getKey()+","+
        MonitorField.NAME.getKey()+","+
        MonitorField.DESCR.getKey();
    
    public ApcPduStateFilter(String agents, String selector) {
        super("ApcPdu",agents,selector, "", true, FIELDS);
    }

    
    @Override
    public List<String> getDisplayPath(String originPath) {
        originPath = originPath.replace("state/", "state//");
        if ( originPath.endsWith("PduOutletState") ) {
            originPath = originPath.replace("/PduOutletState", "");
            int lastSlash = originPath.lastIndexOf("/");
            originPath = originPath.substring(0,lastSlash)+"//outlets/"+originPath.substring(lastSlash);
        } else {
            int lastSlash = originPath.lastIndexOf("/");
            originPath = originPath.substring(0, lastSlash)+"/"+originPath.substring(lastSlash);        
            
        }        
        return Collections.singletonList(originPath);
    }
           
}
