/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.awt.Color;
import java.util.List;
import javax.swing.JOptionPane;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas.MonitorFilter;

public class MonitorFormatter
extends MonitorFormat {
    public FormattedValue format(FormattedValue fv) {
        if ("ON".equals(fv.value) || "OFF".equals(fv.value)) {
            if (fv.bgColor == null) {
                Color color = fv.bgColor = fv.value.equals("ON") ? COLOR_GOOD : COLOR_WARN;
            }
            if (fv.toolTip == null) {
                fv.toolTip = "Click to switch ON/OFF";
            }
            fv.click1 = cell -> {
                String[] ss;
                AgentChannel channel;
                List hh;
                if (cell != null && (hh = cell.getChannels()).size() == 1 && (channel = ((ChannelHandle)hh.get(0)).getChannel()) != null && (ss = MonitorFilter.getPduAndOutletName(channel.getPath())) != null) {
                    String status = channel.get().toString();
                    boolean on = "ON".equals(status);
                    status = on ? "OFF" : "ON";
                    int flip = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>Switch the power outlet<br><b>" + ss[1] + "</b> " + status + "?", "Switch PDU outlet " + status, 2);
                    if (flip == 0) {
                        Console.getConsole().sendCommand(ss[0] + (on ? "/outletOff" : "/outletOn"), new Object[]{ss[1]});
                    }
                }
            };
        }
        return super.format(fv);
    }

    private String getOutletName(AgentChannel channel) {
        String path = channel.getLocalPath();
        int i = path.lastIndexOf("/PduOutletState");
        if (i == -1) {
            return null;
        }
        int ii = path.lastIndexOf("/", i - 1);
        if (ii == -1) {
            return null;
        }
        return path.substring(ii + 1, i);
    }
}

