package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.*;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduProperties;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

/**
 *
 * @author The LSST CCS Team
 */
@Plugin(name = "Apc Pdu plugin NEW", description = "Displays Outlet states and monitoring channels for Apc Pdu")
public class ApcPduPluginNew extends ConsolePlugin {

    private final OptionalPage apcpduOptionalPage = new ApcPduPluginNew.ApcPduOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().getOptionalPageService().add(apcpduOptionalPage);
    }

    static class ApcPduOptionalPage implements OptionalPage {

        private final Map<AgentInfo,List<String>> listOfPdus = new HashMap<>();
        private HashMap<String,MonitorView> views = new HashMap<>();
        
        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (!agent.getAgentProperty(PduProperties.HAS_PDU,"").isEmpty()) {
                String pdus = agent.getAgentProperty(PduProperties.PDU_COMPONENTS,"");
                listOfPdus.put(agent, new ArrayList<>(Arrays.asList( pdus.split(","))));
                return "CCS Subsystems/"+agent.getName() +"/APC PDU";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            MonitorView view = new DefaultView();
            view.setFormatter(MonitorFilter.FORMAT);
            MonitorFilter filter = new MonitorFilter(agent);
            view.setFilter(filter);
            view.setName(agent.getName() +":PDU");
            views.put(getPage(agent), view);
            return view.getPanel();
        }

        @Override
        public void opened(String page) {
            MonitorView view = views.get(page);
            if (view != null) {
                view.install();
            }
        }

        @Override
        public void closed(String page) {
            MonitorView view = views.remove(page);
            if (view != null) {
                view.uninstall();
            }
        }

    }
}
