package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.filter.GenericFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Apc Pdu monitoring channel filter.
 *
 * @author The LSST CCS Team
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Apc Pdu monitoring filter",
               path="Subsystems/ApcPdu",
               description="Apc Pdu monitoring channel filter.")
public class ApcPduMonitorFilter extends GenericFilter {


    public final static String FIELDS = 
        MonitorField.VALUE.getKey()+","+
        MonitorField.UNITS.getKey()+","+
        MonitorField.LOW_ALARM.getKey()+","+
        MonitorField.LOW_WARN.getKey()+","+
        MonitorField.ALERT_LOW.getKey()+","+
        MonitorField.HIGH_WARN.getKey()+","+
        MonitorField.HIGH_ALARM.getKey()+","+
        MonitorField.ALERT_HIGH.getKey()+","+
        MonitorField.NAME.getKey()+","+
        MonitorField.DESCR.getKey();
    
    public ApcPduMonitorFilter(String agents, String selector) {
        super("ApcPdu",agents,selector, "", true, FIELDS);        
    }

    
    @Override
    public List<String> getDisplayPath(String originPath) {
        int i1 = originPath.indexOf("/");
        int i2 = originPath.indexOf("/", i1+1);
        if (i1 == -1 || i2 == -1) return Collections.emptyList();
        String displayPath = originPath.substring(i1 + 1, i2) +"//"+ originPath.substring(i2 + 1);
        return Collections.singletonList(displayPath);
    }
           
}
