/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.pattern.PatternUtils;

public class LogPropertiesLoader {
    public static final String LOG_PROPS = "/logging.properties";
    public static final String LOG_CONF_FILE = System.getProperty("java.util.logging.config.file", "/logging.properties");
    static LogManager systemLoaderLogManager;
    Properties loggingProperties;

    public LogPropertiesLoader() {
        systemLoaderLogManager = LogManager.getLogManager();
        this.readInitialConfiguration();
    }

    public static Optional<LogManager> getSystemLoaderLogManager() {
        Optional<LogManager> res = Optional.empty();
        try {
            if (systemLoaderLogManager == null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("org.lsst.ccs.utilities.logging.LogPropertiesLoader");
                clazz.newInstance();
            }
        }
        catch (Exception exc) {
            System.err.println(" ERROR " + exc);
        }
        res = Optional.ofNullable(systemLoaderLogManager);
        return res;
    }

    void readInitialConfiguration() {
        String string;
        String resourceName = LOG_CONF_FILE;
        String dummyCheckProperty = "ccsLoaded";
        if (null != systemLoaderLogManager.getProperty(dummyCheckProperty)) {
            return;
        }
        this.loggingProperties = new Properties();
        Properties props = BootstrapResourceUtils.getBootstrapProperties(resourceName, this.getClass());
        Set<Object> keys = BootstrapResourceUtils.getAllKeysInProperties(props);
        for (Object object : keys) {
            this.loggingProperties.put(object, props.getProperty((String)object));
        }
        this.loggingProperties.setProperty(dummyCheckProperty, "true");
        Set<String> set = this.loggingProperties.stringPropertyNames();
        for (String key : set) {
            if (!key.endsWith(".pattern")) continue;
            String pattern = this.loggingProperties.getProperty(key);
            try {
                pattern = this.checkForFile(pattern);
                this.loggingProperties.put(key, pattern);
            }
            catch (IOException e) {
                System.err.println("problem while creating log directory " + e);
            }
            break;
        }
        if ((string = this.loggingProperties.getProperty("handlersN")) != null) {
            throw new RuntimeException("handlersN property and custom handler are no longer in use. Use 'handler' property and standard handlers");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.loggingProperties.store(bos, "");
            byte[] bytes = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            systemLoaderLogManager.readConfiguration(bis);
        }
        catch (IOException e) {
            System.err.println(" can't load properties for LogManager" + e);
        }
    }

    protected String replace(String str, Properties props) {
        String propName;
        String replacement;
        int pos_end;
        String result = str;
        int pos_start = result.indexOf("${");
        if (pos_start != -1 && (pos_end = result.indexOf(125)) != -1 && (replacement = props.getProperty(propName = result.substring(pos_start + 2, pos_end))) != null) {
            result = pos_start > 0 ? result.substring(0, pos_start) + replacement + this.replace(result.substring(pos_end + 1), props) : replacement + this.replace(result.substring(pos_end + 1), props);
        }
        return result;
    }

    String checkForFile(String filePattern) throws IOException {
        int lastSlash = (filePattern = PatternUtils.resolvePattern(filePattern)).lastIndexOf(47);
        if (lastSlash >= 0) {
            String directorySpec = filePattern.substring(0, lastSlash);
            Files.createDirectories(FileSystems.getDefault().getPath(directorySpec, new String[0]), new FileAttribute[0]);
        }
        return filePattern;
    }

    public static String loaderGetProperty(String name) {
        LogPropertiesLoader.getSystemLoaderLogManager();
        try {
            String res = systemLoaderLogManager.getProperty(name);
            return res;
        }
        catch (Exception e) {
            System.err.println(" loaderGetProperty :" + e);
            return null;
        }
    }

    public static String loaderGetStringProperty(String name, String defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    public static int loaderGetIntProperty(String name, int defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Level loaderGetLevelProperty(String name, Level defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Formatter loaderGetFormatterProperty(String name, Formatter defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        try {
            if (val != null) {
                Class<?> clazz = LogPropertiesLoader.class.getClassLoader().loadClass(val);
                return (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    private synchronized void setLevelOnExistingLogger(String loggerName, Logger logger) {
        Level level = this.getLevelProperty(loggerName + ".level", null);
        if (level != null) {
            logger.setLevel(level);
        }
    }

    public String getProperty(String property) {
        return systemLoaderLogManager.getProperty(property);
    }

    public String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    public int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    public Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

