package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

/**
 *
 * @author turri
 */
public class MonitorAssembly extends JPanel {

    private final MonitorTrendingTable table;
    private final MonitorPanel panel;
    
    public MonitorAssembly(CommandSender sender)
    {
        setLayout(new BorderLayout());
        table = new MonitorTrendingTable(sender);
        add(table, BorderLayout.CENTER);
        
        panel = new MonitorPanel(sender);
        add(panel, BorderLayout.SOUTH);
    }

    public MonitorTrendingTable getTrendingTable()
    {
        return table;
    }
    
    public MonitorPanel getControlPanel()
    {
        return panel;
    }
    
    public void setSubsystems(String... sNames)
    {
        table.setSubsystems(sNames);
        panel.setSubsystems(sNames);
    }
    
    public void handleData(String source, String key, Object o)
    {
        if (key.equals(MonitorState.KEY)) {
            MonitorState ms = (MonitorState)((KeyValueData)o).getValue();
            table.updateTableState(source, ms);
            panel.updatePanel(source, areLimitsChanged(ms));
        }
        else if (o instanceof KeyValueDataList) {
            boolean trending = false;
            for (KeyValueData data : (KeyValueDataList)o) {
                if (data.getType() == KeyValueData.KeyValueDataType
                                        .KeyValueTrendingData) {
                    table.updateTableValue(source, data.getKey(),
                                           (Double)data.getValue());
                    trending = true;
                }
                else if (data.getType() == KeyValueData.KeyValueDataType
                                            .KeyValueMetaData) {
                    table.updateTableLimit(source, key, data.getKey(),
                                           (String)data.getValue());
                }
            }
            if (trending) {
                panel.updateTime();
            }
        }
    }

    public void updateTableModel(String sName, MonitorFullState status)
    {
        table.updateTableModel(sName, status);
        panel.updateTime();
        panel.updatePanel(sName, areLimitsChanged(status.getMonitorState()));
    }

    public void disableSystem(String sName)
    {
        table.disableSystem(sName);
        panel.disableSystem(sName);
    }

    private boolean areLimitsChanged(MonitorState status)
    {
        return !status.getLowLimitChange().isEmpty()
                 | !status.getHighLimitChange().isEmpty();
    }

    private static final long serialVersionUID = 1L;
}
