package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.Color;
import java.awt.Font;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

/**
 *
 * @author turri
 */
public class MonitorPanel extends javax.swing.JPanel {

    final static Font f = new java.awt.Font("Tahoma", 1, 12);
    final static Color RED = new Color(150, 0, 0), GREEN = new Color(0, 150, 0);
    CommandSender gui;
    Map<String, SubsysDesc> subsysMap = new HashMap<>();

    public MonitorPanel(CommandSender gui) {
        this.gui = gui;
        initComponents();
        timeLabel.setFont(f);
        timeValue.setFont(f);
        limitsButton.setFont(f);
        (new UpdateStatus()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        limitsButton = new javax.swing.JButton();
        timeValue = new javax.swing.JLabel();
        timeLabel = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        limitsButton.setText("Save Limits");
        limitsButton.setEnabled(false);
        limitsButton.setFocusable(false);
        limitsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                limitsButtonActionPerformed(evt);
            }
        });

        timeValue.setText("0000-00-00  00:00:00");

        timeLabel.setText("Last Update:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(timeLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(timeValue, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 50, Short.MAX_VALUE)
                .addComponent(limitsButton)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(6, 6, 6)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(limitsButton)
                    .addComponent(timeLabel)
                    .addComponent(timeValue))
                .addGap(0, 4, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void limitsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_limitsButtonActionPerformed
        for (SubsysDesc desc : subsysMap.values()) {
            if (desc.limitChanged) {
                gui.sendCommand(desc.name, null, "saveConfig");
            }
        }
        limitsButton.setEnabled(false);
    }//GEN-LAST:event_limitsButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton limitsButton;
    private javax.swing.JLabel timeLabel;
    private javax.swing.JLabel timeValue;
    // End of variables declaration//GEN-END:variables

    public void setSubsystems(String... sNames)
    {
        for (String sName : sNames) {
            SubsysDesc desc = new SubsysDesc();
            desc.name = sName;
            subsysMap.put(sName, desc);
        }
    }

    public void updatePanel(String sName, Boolean limitChanged) {
        if (limitChanged == null) return;
        SubsysDesc desc = subsysMap.get(sName);
        if (desc == null) return;
        desc.limitChanged = limitChanged;
        SwingUtilities.invokeLater(new UpdateStatus());
    }

    public void updateTime() {
        SwingUtilities.invokeLater(new UpdateTime());
    }

    public void disableSystem(String sName) {
        updatePanel(sName, false);
    }

    javax.swing.JButton getLimitsButton() {
        return limitsButton;
    }

    class SubsysDesc {
        String name;
        boolean limitChanged;
    }

    class UpdateStatus implements Runnable {

        @Override
        public void run() {
            boolean limitsChanged = false;
            for (SubsysDesc desc : subsysMap.values()) {
                limitsChanged |= desc.limitChanged;
            }
            limitsButton.setEnabled(limitsChanged);
        }

    }

    class UpdateTime implements Runnable {

        @Override
        public void run() {
            showTime();
        }
    }

    private void showTime()
    {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        timeValue.setText(String.format("%tY-%<tm-%<td  %<tH:%<tM:%<tS", cal));
    }

    private static final long serialVersionUID = 1L;
}
