/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.bus.messages.MetadataStatus;
import org.lsst.ccs.plugin.jas3.trending.TrendingService;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class MonitorTrendingTable
extends JPanel {
    static final String[] colNames = new String[]{"Description", "Value", "Units", "Low Limit", "Al.", "High Limit", "Al.", "Name"};
    static final Class[] colTypes = new Class[]{String.class, TrendingValue.class, String.class, Double.class, AlarmMarker.class, Double.class, AlarmMarker.class, String.class};
    static final Color colGood = new Color(160, 255, 160);
    static final Color colError = new Color(255, 160, 160);
    static final Color colOffln = new Color(160, 200, 255);
    static final Color colPopup = new Color(255, 255, 160);
    static final Font myFont = new Font("Helvetica", 0, 12);
    static final Font changeFont = new Font("Helvetica", 1, 12);
    static final int DESCRIPTION_IND = 0;
    static final int VALUE_IND = 1;
    static final int UNITS_IND = 2;
    static final int LOW_LIMIT_IND = 3;
    static final int LOW_ALARM_IND = 4;
    static final int HIGH_LIMIT_IND = 5;
    static final int HIGH_ALARM_IND = 6;
    static final int NAME_IND = 7;
    private JScrollPane pane;
    private JTable table;
    Map<String, SubsysDesc> subsysMap = new HashMap<String, SubsysDesc>();
    CommandSender sender;
    int lastFocusRow;
    Popup popup;
    private static final long serialVersionUID = 1L;

    public MonitorTrendingTable(CommandSender sender) {
        this.initComponents();
        JTableHeader hdr = this.table.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        this.table.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
        this.table.setDefaultRenderer(Double.class, new LimitsCellRenderer());
        this.table.setDefaultRenderer(String.class, new TextCellRenderer());
        this.table.setDefaultRenderer(AlarmMarker.class, new AlarmCellRenderer());
        this.table.setAutoResizeMode(3);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setFont(myFont);
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.sender = sender;
    }

    private void initComponents() {
        this.pane = new JScrollPane();
        this.table = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.table.setModel(new TrendingTableModel());
        this.table.setName("monTable");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MonitorTrendingTable.this.tableMouseClicked(evt);
            }
        });
        this.pane.setViewportView(this.table);
        this.add(this.pane);
    }

    private void tableMouseClicked(MouseEvent evt) {
        Point point;
        JTable source;
        int row;
        SubsysDesc desc;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        if ((desc = this.findSubsys(row = (source = (JTable)evt.getSource()).rowAtPoint(point = evt.getPoint()))) == null) {
            return;
        }
        if (evt.getClickCount() == 1) {
            int column = source.columnAtPoint(point);
            if (column != 4 && column != 6) {
                return;
            }
            String name = (String)source.getModel().getValueAt(row, column);
            if (name == null || name.length() == 0) {
                return;
            }
            PopupFactory fact = PopupFactory.getSharedInstance();
            this.popup = fact.getPopup(null, desc.alarmMap.get(name), evt.getXOnScreen(), evt.getYOnScreen());
            this.popup.show();
        } else if (evt.getClickCount() == 2) {
            String name = (String)source.getModel().getValueAt(row, 7);
            if (name.length() == 0) {
                return;
            }
            String[] path = new String[]{desc.name, name};
            Studio studio = (Studio)Studio.getApplication();
            if (studio == null) {
                return;
            }
            TrendingService trending = (TrendingService)studio.getLookup().lookup(TrendingService.class);
            if (trending == null) {
                return;
            }
            trending.show(path);
        }
    }

    public void setSubsystems(String ... sNames) {
        String[] stringArray = sNames;
        int n = sNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sName = stringArray[n2];
            SubsysDesc desc = new SubsysDesc();
            desc.name = sName;
            this.subsysMap.put(sName, desc);
            ++n2;
        }
    }

    public void updateTableModel(String sName, MonitorFullState status) {
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(desc, status));
    }

    public void updateTableValue(String sName, String iName, double value) {
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTableValue(desc, iName, value));
    }

    public void updateTableLimit(MetadataStatus status) {
        SubsysDesc desc = this.subsysMap.get(status.getOriginAgentInfo().getName());
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateLimitValue(desc, status));
    }

    public void updateTableState(String sName, MonitorState status) {
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateState(desc, status));
    }

    public void disableSystem(String sName) {
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new DisableSystem(desc));
    }

    SubsysDesc findSubsys(int row) {
        for (SubsysDesc desc : this.subsysMap.values()) {
            if (row < desc.start || row >= desc.end) continue;
            return desc;
        }
        return null;
    }

    String getFormat(int row) {
        SubsysDesc desc = this.findSubsys(row);
        int sRow = desc.tsRowMap.get(row - desc.start);
        return sRow < 0 ? "" : desc.formats.get(sRow);
    }

    Color getChannelColor(int row) {
        SubsysDesc desc = this.findSubsys(row);
        int sRow = desc.tsRowMap.get(row - desc.start);
        return sRow < 0 ? Color.WHITE : (!desc.enabled ? Color.LIGHT_GRAY : (!desc.onlineChans.get(sRow) ? colOffln : (desc.goodChans.get(sRow) ? colGood : colError)));
    }

    boolean hasLowLimitChanged(int row) {
        SubsysDesc desc = this.findSubsys(row);
        int sRow = desc.tsRowMap.get(row - desc.start);
        return sRow >= 0 ? desc.lowLimitChange.get(sRow) : false;
    }

    boolean hasHighLimitChanged(int row) {
        SubsysDesc desc = this.findSubsys(row);
        int sRow = desc.tsRowMap.get(row - desc.start);
        return sRow >= 0 ? desc.highLimitChange.get(sRow) : false;
    }

    boolean isNewSection(int row) {
        SubsysDesc desc = this.findSubsys(row);
        return desc.tsRowMap.get(row - desc.start) < 0;
    }

    private static String fmt(String format, double value) {
        return String.format(format, value);
    }

    class AlarmCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        AlarmCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text = (String)value;
            text = text == null || text.length() == 0 ? "" : "  \u2713";
            return super.getTableCellRendererComponent(table, text, false, false, row, column);
        }
    }

    class AlarmMarker {
        AlarmMarker() {
        }
    }

    class DisableSystem
    implements Runnable {
        SubsysDesc desc;

        DisableSystem(SubsysDesc desc) {
            this.desc = desc;
        }

        @Override
        public void run() {
            this.desc.enabled = false;
            int row = this.desc.start;
            while (row < this.desc.end) {
                MonitorTrendingTable.this.table.setValueAt(MonitorTrendingTable.this.table.getValueAt(row, 1), row, 1);
                ++row;
            }
        }
    }

    class LimitsCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        LimitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                Component c = super.getTableCellRendererComponent(table, "", false, false, row, column);
                return c;
            }
            String text = MonitorTrendingTable.fmt(MonitorTrendingTable.this.getFormat(row), (Double)value);
            Component c = super.getTableCellRendererComponent(table, text, false, hasFocus, row, column);
            if (column == 3 && MonitorTrendingTable.this.hasLowLimitChanged(row) || column == 5 && MonitorTrendingTable.this.hasHighLimitChanged(row)) {
                c.setFont(changeFont);
                c.setForeground(Color.blue);
            } else {
                c.setForeground(Color.black);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            if (hasFocus) {
                MonitorTrendingTable.this.lastFocusRow = row;
            }
            return c;
        }
    }

    class SubsysDesc {
        String name;
        int start;
        int size;
        int end;
        boolean indent;
        boolean enabled;
        Map<String, JLabel> alarmMap = new HashMap<String, JLabel>();
        Map<String, Integer> chanMap = new HashMap<String, Integer>();
        List<Integer> tsRowMap = new ArrayList<Integer>();
        List<Integer> stRowMap = new ArrayList<Integer>();
        BitSet goodChans = new BitSet();
        BitSet onlineChans = new BitSet();
        BitSet lowLimitChange = new BitSet();
        BitSet highLimitChange = new BitSet();
        List<Double> lowLimits = new ArrayList<Double>();
        List<Double> highLimits = new ArrayList<Double>();
        List<String> formats = new ArrayList<String>();

        SubsysDesc() {
        }
    }

    class TextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, "  " + (String)value, false, false, row, column);
            if (column == 0 && MonitorTrendingTable.this.isNewSection(row)) {
                c.setFont(changeFont);
            }
            return c;
        }
    }

    class TrendingTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TrendingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c;
            if (value == null) {
                c = super.getTableCellRendererComponent(table, "", false, false, row, column);
                c.setBackground(Color.WHITE);
            } else {
                String text = MonitorTrendingTable.fmt(MonitorTrendingTable.this.getFormat(row), (Double)value);
                c = super.getTableCellRendererComponent(table, text, false, false, row, column);
                c.setBackground(MonitorTrendingTable.this.getChannelColor(row));
                ((JLabel)c).setHorizontalAlignment(4);
            }
            return c;
        }
    }

    class TrendingTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 1L;

        public TrendingTableModel() {
            super(colNames, 0);
            this.addTableModelListener(this);
        }

        public Class getColumnClass(int column) {
            return colTypes[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return (column == 3 || column == 5) && this.getValueAt(row, column) != null;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            double oldValue;
            int column = e.getColumn();
            if (column != 3 && column != 5) {
                return;
            }
            boolean isLow = column == 3;
            int row = e.getFirstRow();
            SubsysDesc desc = MonitorTrendingTable.this.findSubsys(row);
            int sRow = desc.tsRowMap.get(row - desc.start);
            double newValue = (Double)this.getValueAt(row, column);
            if (newValue != (oldValue = (isLow ? desc.lowLimits.get(sRow) : desc.highLimits.get(sRow)).doubleValue())) {
                this.setValueAt(oldValue, row, column);
                MonitorTrendingTable.this.sender.sendCommand(desc.name, (String)this.getValueAt(row, 7), "change", isLow ? "limitLo" : "limitHi", newValue);
            }
        }

        void addTrendingRow(SubsysDesc desc, MonitorChan chan) {
            String[] descrip = chan.getDescription().split("\\\\", 2);
            if (descrip.length == 2) {
                if (descrip[0].length() == 0) {
                    desc.indent = false;
                } else {
                    Object[] objectArray = new Object[8];
                    objectArray[0] = descrip[0];
                    objectArray[2] = "";
                    objectArray[4] = "";
                    objectArray[6] = "";
                    objectArray[7] = "";
                    this.insertRow(desc.end++, objectArray);
                    desc.tsRowMap.add(-1);
                    desc.indent = true;
                }
                descrip[0] = descrip[1];
            }
            desc.chanMap.put(chan.getName(), desc.tsRowMap.size());
            desc.stRowMap.add(desc.tsRowMap.size());
            desc.tsRowMap.add(desc.lowLimits.size());
            desc.lowLimits.add(chan.getLowLimit());
            desc.highLimits.add(chan.getHighLimit());
            this.insertRow(desc.end++, new Object[]{String.valueOf(desc.indent ? "   " : "") + descrip[0], chan.getValue(), chan.getUnits(), chan.getLowLimit(), chan.getLowAlarm(), chan.getHighLimit(), chan.getHighAlarm(), chan.getName()});
        }

        void updateValue(SubsysDesc desc, String name, double value) {
            Integer tRow = desc.chanMap.get(name);
            if (tRow == null) {
                return;
            }
            this.setValueAt(value, desc.start + tRow, 1);
        }

        void updateLimitValue(SubsysDesc desc, MetadataStatus s) {
            Integer column;
            boolean high = s.getMetadataName().equals("alarmHigh");
            double limit = Double.valueOf(s.getMetadataValue());
            Integer tRow = desc.chanMap.get(s.getDataName());
            if (tRow == null) {
                return;
            }
            if (high) {
                desc.highLimits.set(desc.tsRowMap.get(tRow), limit);
                column = 5;
            } else {
                desc.lowLimits.set(desc.tsRowMap.get(tRow), limit);
                column = 3;
            }
            this.setValueAt(limit, desc.start + tRow, column);
        }

        void updateState(SubsysDesc desc, MonitorState s) {
            desc.goodChans = s.getGoodChans();
            desc.onlineChans = s.getOnlineChans();
            BitSet updateHigh = (BitSet)s.getHighLimitChange().clone();
            updateHigh.xor(desc.highLimitChange);
            desc.highLimitChange.xor(updateHigh);
            int sRow = updateHigh.nextSetBit(0);
            while (sRow >= 0) {
                this.setValueAt(desc.highLimits.get(sRow), desc.start + desc.stRowMap.get(sRow), 5);
                sRow = updateHigh.nextSetBit(sRow + 1);
            }
            BitSet updateLow = (BitSet)s.getLowLimitChange().clone();
            updateLow.xor(desc.lowLimitChange);
            desc.lowLimitChange.xor(updateLow);
            int sRow2 = updateLow.nextSetBit(0);
            while (sRow2 >= 0) {
                this.setValueAt(desc.lowLimits.get(sRow2), desc.start + desc.stRowMap.get(sRow2), 3);
                sRow2 = updateLow.nextSetBit(sRow2 + 1);
            }
        }
    }

    class TrendingValue {
        TrendingValue() {
        }
    }

    class UpdateLimitValue
    implements Runnable {
        SubsysDesc desc;
        MetadataStatus s;

        UpdateLimitValue(SubsysDesc desc, MetadataStatus s) {
            this.desc = desc;
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.table.getModel()).updateLimitValue(this.desc, this.s);
        }
    }

    class UpdateState
    implements Runnable {
        SubsysDesc desc;
        MonitorState s;

        UpdateState(SubsysDesc desc, MonitorState s) {
            this.desc = desc;
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.table.getModel()).updateState(this.desc, this.s);
        }
    }

    class UpdateTableValue
    implements Runnable {
        SubsysDesc desc;
        String n;
        double v;

        UpdateTableValue(SubsysDesc desc, String n, double v) {
            this.desc = desc;
            this.n = n;
            this.v = v;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.table.getModel()).updateValue(this.desc, this.n, this.v);
        }
    }

    class UpdateTrendingTableModel
    implements Runnable {
        SubsysDesc desc;
        MonitorFullState s;

        UpdateTrendingTableModel(SubsysDesc desc, MonitorFullState s) {
            this.desc = desc;
            this.s = s;
        }

        @Override
        public void run() {
            this.desc.indent = false;
            this.desc.enabled = true;
            this.desc.alarmMap.clear();
            this.desc.chanMap.clear();
            this.desc.tsRowMap.clear();
            this.desc.stRowMap.clear();
            this.desc.goodChans.clear();
            this.desc.onlineChans.clear();
            this.desc.lowLimitChange.clear();
            this.desc.highLimitChange.clear();
            this.desc.lowLimits.clear();
            this.desc.highLimits.clear();
            Map alarms = this.s.getAlarms();
            for (String name : alarms.keySet()) {
                JLabel label = new JLabel((String)alarms.get(name));
                label.setBorder(LineBorder.createBlackLineBorder());
                label.setBackground(colPopup);
                label.setFont(myFont);
                this.desc.alarmMap.put(name, label);
            }
            TrendingTableModel model = (TrendingTableModel)MonitorTrendingTable.this.table.getModel();
            int j = 0;
            while (j < this.desc.size) {
                model.removeRow(this.desc.start);
                ++j;
            }
            this.desc.end = this.desc.start;
            for (MonitorChan chan : this.s.getChannels()) {
                model.addTrendingRow(this.desc, chan);
            }
            this.desc.size = this.desc.end - this.desc.start;
            int row = 0;
            for (SubsysDesc d : MonitorTrendingTable.this.subsysMap.values()) {
                d.start = row;
                d.end = row += d.size;
            }
            int c = 0;
            while (c < MonitorTrendingTable.this.table.getColumnCount()) {
                TableColumnModel colModel = MonitorTrendingTable.this.table.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr = MonitorTrendingTable.this.table.getTableHeader().getDefaultRenderer();
                Component comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.table, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                rndr = MonitorTrendingTable.this.table.getCellRenderer(0, c);
                Class<?> colClass = MonitorTrendingTable.this.table.getColumnClass(c);
                if (colClass.equals(String.class) || colClass.equals(AlarmMarker.class)) {
                    int r = this.desc.start;
                    while (r < this.desc.end) {
                        Object value = MonitorTrendingTable.this.table.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.table, value, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                        ++r;
                    }
                } else {
                    comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.table, -999.99, false, false, 0, c);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
                col.setPreferredWidth(width + 4);
                col.setMinWidth(width + 4);
                ++c;
            }
            model.updateState(this.desc, this.s.getMonitorState());
            Container anc = MonitorTrendingTable.this.getTopLevelAncestor();
            if (anc instanceof Window) {
                Dimension td = MonitorTrendingTable.this.table.getPreferredSize();
                Dimension wd = anc.getSize();
                wd.width = Math.max(wd.width, td.width);
                anc.setSize(wd);
            }
        }
    }
}

