package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

/**
 *
 * @author turri
 */
public class MonitorAssembly extends javax.swing.JPanel {

    private final MonitorTrendingTable table;
    private final MonitorPanel panel;
    
    public MonitorAssembly(CommandSender sender)
    {
        setLayout(new BorderLayout());
        table = new MonitorTrendingTable(sender);
        add(table, BorderLayout.CENTER);
        panel = new MonitorPanel(sender);
        add(panel, BorderLayout.SOUTH);
    }

    public MonitorTrendingTable getTrendingTable()
    {
        return table;
    }
    
    public MonitorPanel getControlPanel()
    {
        return panel;
    }
    
    public void setSubsystems(String... sNames)
    {
        table.setSubsystems(sNames);
        panel.setSubsystems(sNames);
    }
    
    public void handleData(String source, String key, Object d)
    {
        if (key.equals(MonitorState.KEY) && d instanceof MonitorState) {
            table.updateTableState(source, (MonitorState)d);
            panel.updatePanel(source, areLimitsChanged((MonitorState)d));
        }
        else if (d instanceof Double) {
            table.updateTableValue(source, key, (Double)d);
            panel.updateTime();
        }
    }

    public void handleStatus(BusMessage s)
    {
        if (s instanceof MetadataStatus) {
            table.updateTableLimit((MetadataStatus)s);
        }
    }

    public void updateTableModel(String sName, MonitorFullState status)
    {
        table.updateTableModel(sName, status);
        panel.updateTime();
        panel.updatePanel(sName, areLimitsChanged(status.getMonitorState()));
    }

    @Deprecated
    public void enableSystem()
    {
        panel.enableSystem();
    }

    @Deprecated
    public void disableSystem()
    {
        panel.disableSystem();
    }

    public void disableSystem(String sName)
    {
        table.disableSystem(sName);
        panel.disableSystem(sName);
    }

    private boolean areLimitsChanged(MonitorState status)
    {
        return !status.getLowLimitChange().isEmpty()
                 | !status.getHighLimitChange().isEmpty();
    }

    private static final long serialVersionUID = 1L;
}
