/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorPanel;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;

public class MonitorAssembly
extends JPanel {
    private final MonitorTrendingTable table;
    private final MonitorPanel panel;

    public MonitorAssembly(CommandSender sender) {
        this.initComponents();
        this.table = new MonitorTrendingTable(sender);
        this.add((Component)this.table, "Center");
        this.panel = new MonitorPanel(sender);
        this.add((Component)this.panel, "South");
    }

    public MonitorTrendingTable getTrendingTable() {
        return this.table;
    }

    public MonitorPanel getControlPanel() {
        return this.panel;
    }

    public void setSubsystems(String ... sNames) {
        this.table.setSubsystems(sNames);
        this.panel.setSubsystems(sNames);
    }

    public void handleData(String source, String key, Object d) {
        if (key.equals("MonitorState") && d instanceof MonitorState) {
            this.table.updateTableState(source, (MonitorState)d);
            this.panel.updatePanel(source, this.areLimitsChanged((MonitorState)d));
        } else if (d instanceof Double) {
            this.table.updateTableValue(source, key, (Double)d);
            this.panel.updateTime();
        }
    }

    public void handleStatus(BusMessage s) {
        if (s instanceof MetadataStatus) {
            this.table.updateTableLimit((MetadataStatus)s);
        }
    }

    public void updateTableModel(String sName, MonitorFullState status) {
        this.table.updateTableModel(sName, status);
        this.panel.updateTime();
        this.panel.updatePanel(sName, this.areLimitsChanged(status.getMonitorState()));
    }

    public void enableSystem() {
        this.panel.enableSystem();
    }

    public void disableSystem() {
        this.panel.disableSystem();
    }

    private boolean areLimitsChanged(MonitorState status) {
        return !status.getLowLimitChange().isEmpty() | !status.getHighLimitChange().isEmpty();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

