package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

/**
 *
 * @author turri
 */
public class MonitorAssembly extends javax.swing.JPanel {

    private final MonitorTrendingTable table;
    private final MonitorPanel panel;
    
    
    public MonitorAssembly(CommandSender sender)
    {
        initComponents();
        table = new MonitorTrendingTable(sender);
        add(table, BorderLayout.CENTER);
        
        panel = new MonitorPanel(sender);
        add(panel, BorderLayout.SOUTH);
    }

    public MonitorTrendingTable getTrendingTable()
    {
        return table;
    }
    
    public MonitorPanel getControlPanel()
    {
        return panel;
    }
    
    public void setSubsystems(String... sNames)
    {
        table.setSubsystems(sNames);
        panel.setSubsystems(sNames);
    }
    
    public void handleData(String source, String key, Object d)
    {
        if (key.equals(MonitorState.KEY) && d instanceof MonitorState) {
            table.updateTableState(source, (MonitorState)d);
            panel.updatePanel(source, areLimitsChanged((MonitorState)d));
        }
        else if (d instanceof Double) {
            table.updateTableValue(source, key, (Double)d);
            panel.updateTime();
        }
    }

    public void handleStatus(BusMessage s)
    {
        if (s instanceof TrendingStatus) {
            table.updateTableValues((TrendingStatus)s);
            panel.updateTime();
        }
        else if (s instanceof MetadataStatus) {
            table.updateTableLimit((MetadataStatus)s);
        }
    }

    public void updateTableModel(String sName, MonitorFullState status)
    {
        table.updateTableModel(sName, status);
        panel.updateTime();
        panel.updatePanel(sName, areLimitsChanged(status.getMonitorState()));
    }

    public void enableSystem()
    {
        panel.enableSystem();
    }

    public void disableSystem()
    {
        panel.disableSystem();
    }

    private boolean areLimitsChanged(MonitorState status)
    {
        return !status.getLowLimitChange().isEmpty()
                 | !status.getHighLimitChange().isEmpty();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
