/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.plugin.jas3.trending.TrendingService;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class MonitorTrendingTable
extends JPanel {
    static final String[] colNames = new String[]{"Description", "Value", "Units", "Low Limit", "High Limit", "Name"};
    static final Class[] colTypes = new Class[]{String.class, TrendingValue.class, String.class, Double.class, Double.class, String.class};
    static final Color colGood = new Color(160, 255, 160);
    static final Color colError = new Color(255, 160, 160);
    static final Color colOffln = new Color(160, 160, 255);
    static final Font myFont = new Font("Helvetica", 0, 12);
    static final Font changeFont = new Font("Helvetica", 1, 12);
    static final int DESCRIPTION_IND = 0;
    static final int VALUE_IND = 1;
    static final int UNITS_IND = 2;
    static final int LOW_LIMIT_IND = 3;
    static final int HIGH_LIMIT_IND = 4;
    static final int NAME_IND = 5;
    Map<String, SubsysDesc> subsysMap = new HashMap<String, SubsysDesc>();
    CommandSender sender;
    int lastFocusRow;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public MonitorTrendingTable(CommandSender sender) {
        this.initComponents();
        JTableHeader hdr = this.jTable1.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        this.jTable1.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
        this.jTable1.setDefaultRenderer(Double.class, new LimitsCellRenderer());
        this.jTable1.setDefaultRenderer(String.class, new TextCellRenderer());
        this.jTable1.setAutoResizeMode(3);
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setFont(myFont);
        this.jTable1.setRowHeight(this.jTable1.getRowHeight() + 2);
        this.sender = sender;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.jTable1.setModel(new TrendingTableModel());
        this.jTable1.setName("monTable");
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MonitorTrendingTable.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1);
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        JTable source = (JTable)evt.getSource();
        int row = source.rowAtPoint(evt.getPoint());
        SubsysDesc desc = this.findSubsys(row);
        if (desc == null) {
            return;
        }
        String name = (String)source.getModel().getValueAt(row, 5);
        if (name.length() == 0) {
            return;
        }
        String[] path = new String[]{desc.name, name};
        Studio studio = (Studio)Studio.getApplication();
        if (studio == null) {
            return;
        }
        TrendingService trending = (TrendingService)studio.getLookup().lookup(TrendingService.class);
        if (trending == null) {
            return;
        }
        trending.show(path);
    }

    public void setSubsystems(String ... sNames) {
        String[] stringArray = sNames;
        int n = sNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sName = stringArray[n2];
            SubsysDesc desc = new SubsysDesc();
            desc.name = sName;
            this.subsysMap.put(sName, desc);
            ++n2;
        }
    }

    public void updateTableModel(String sName, MonitorFullState status) {
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(desc, status));
    }

    public void updateTableValues(TrendingStatus status) {
        SubsysDesc desc = this.subsysMap.get(status.getOrigin());
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTrendingTable(desc, status));
    }

    public void updateTableValue(String sName, String iName, double value) {
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTableValue(desc, iName, value));
    }

    public void updateTableLimit(MetadataStatus status) {
        SubsysDesc desc = this.subsysMap.get(status.getOrigin());
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateLimitValue(desc, status));
    }

    public void updateTableState(String sName, MonitorState status) {
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateState(desc, status));
    }

    SubsysDesc findSubsys(int row) {
        for (SubsysDesc desc : this.subsysMap.values()) {
            if (row < desc.start || row >= desc.end) continue;
            return desc;
        }
        return null;
    }

    int getChannelState(int row) {
        SubsysDesc desc = this.findSubsys(row);
        int sRow = desc.tsRowMap.get(row - desc.start);
        return sRow < 0 ? -2 : (!desc.onlineChans.get(sRow) ? -1 : (!desc.goodChans.get(sRow) ? 0 : 1));
    }

    boolean hasLowLimitChanged(int row) {
        SubsysDesc desc = this.findSubsys(row);
        int sRow = desc.tsRowMap.get(row - desc.start);
        return sRow >= 0 ? desc.lowLimitChange.get(sRow) : false;
    }

    boolean hasHighLimitChanged(int row) {
        SubsysDesc desc = this.findSubsys(row);
        int sRow = desc.tsRowMap.get(row - desc.start);
        return sRow >= 0 ? desc.highLimitChange.get(sRow) : false;
    }

    boolean isNewSection(int row) {
        SubsysDesc desc = this.findSubsys(row);
        return desc.tsRowMap.get(row - desc.start) < 0;
    }

    private static String fmt(double val) {
        return String.format("%.2f  ", val);
    }

    class LimitsCellRenderer
    extends DefaultTableCellRenderer {
        LimitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                Component c = super.getTableCellRendererComponent(table, "", false, false, row, column);
                return c;
            }
            Component c = super.getTableCellRendererComponent(table, MonitorTrendingTable.fmt((Double)value), false, hasFocus, row, column);
            if (column == 3 && MonitorTrendingTable.this.hasLowLimitChanged(row) || column == 4 && MonitorTrendingTable.this.hasHighLimitChanged(row)) {
                c.setFont(changeFont);
                c.setForeground(Color.blue);
            } else {
                c.setForeground(Color.black);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            if (hasFocus) {
                MonitorTrendingTable.this.lastFocusRow = row;
            }
            return c;
        }
    }

    class SubsysDesc {
        String name;
        int start;
        int size;
        int end;
        boolean indent;
        Map<String, Integer> chanMap = new HashMap<String, Integer>();
        List<Integer> tsRowMap = new ArrayList<Integer>();
        List<Integer> stRowMap = new ArrayList<Integer>();
        BitSet goodChans = new BitSet();
        BitSet onlineChans = new BitSet();
        BitSet lowLimitChange = new BitSet();
        BitSet highLimitChange = new BitSet();
        List<Double> lowLimits = new ArrayList<Double>();
        List<Double> highLimits = new ArrayList<Double>();

        SubsysDesc() {
        }
    }

    class TextCellRenderer
    extends DefaultTableCellRenderer {
        TextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, "  " + (String)value, false, false, row, column);
            if (column == 0 && MonitorTrendingTable.this.isNewSection(row)) {
                c.setFont(changeFont);
            }
            return c;
        }
    }

    class TrendingTableCellRenderer
    extends DefaultTableCellRenderer {
        TrendingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c;
            if (value == null) {
                c = super.getTableCellRendererComponent(table, "", false, false, row, column);
                c.setBackground(Color.WHITE);
            } else {
                c = super.getTableCellRendererComponent(table, MonitorTrendingTable.fmt((Double)value), false, false, row, column);
                int state = MonitorTrendingTable.this.getChannelState(row);
                c.setBackground(state > 0 ? colGood : (state == 0 ? colError : (state == -1 ? colOffln : Color.WHITE)));
                ((JLabel)c).setHorizontalAlignment(4);
            }
            return c;
        }
    }

    class TrendingTableModel
    extends DefaultTableModel
    implements TableModelListener {
        public TrendingTableModel() {
            super(colNames, 0);
            this.addTableModelListener(this);
        }

        public Class getColumnClass(int column) {
            return colTypes[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 3 || column == 4) {
                return this.getValueAt(row, column) != null;
            }
            return false;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            double oldValue;
            int column = e.getColumn();
            if (column != 3 && column != 4) {
                return;
            }
            boolean isLow = column == 3;
            int row = e.getFirstRow();
            SubsysDesc desc = MonitorTrendingTable.this.findSubsys(row);
            int sRow = desc.tsRowMap.get(row - desc.start);
            double newValue = (Double)this.getValueAt(row, column);
            if (newValue != (oldValue = (isLow ? desc.lowLimits.get(sRow) : desc.highLimits.get(sRow)).doubleValue())) {
                this.setValueAt(oldValue, row, column);
                MonitorTrendingTable.this.sender.sendCommand(desc.name, (String)this.getValueAt(row, 5), "change", isLow ? "limitLo" : "limitHi", newValue);
            }
        }

        void addTrendingRow(SubsysDesc desc, MonitorChan chan) {
            String[] descrip = chan.getDescription().split("\\\\", 2);
            if (descrip.length == 2) {
                if (descrip[0].length() == 0) {
                    desc.indent = false;
                } else {
                    Object[] objectArray = new Object[6];
                    objectArray[0] = descrip[0];
                    objectArray[2] = "";
                    objectArray[5] = "";
                    this.insertRow(desc.end++, objectArray);
                    desc.tsRowMap.add(-1);
                    desc.indent = true;
                }
                descrip[0] = descrip[1];
            }
            desc.chanMap.put(chan.getName(), desc.tsRowMap.size());
            desc.stRowMap.add(desc.tsRowMap.size());
            desc.tsRowMap.add(desc.lowLimits.size());
            desc.lowLimits.add(chan.getLowLimit());
            desc.highLimits.add(chan.getHighLimit());
            this.insertRow(desc.end++, new Object[]{String.valueOf(desc.indent ? "   " : "") + descrip[0], chan.getValue(), chan.getUnits(), chan.getLowLimit(), chan.getHighLimit(), chan.getName()});
        }

        void updateValues(SubsysDesc desc, TrendingStatus s) {
            for (ValueNotification vn : (List)s.getValue()) {
                Integer tRow = desc.chanMap.get(vn.getName());
                if (tRow == null) {
                    return;
                }
                this.setValueAt(vn.getData(), desc.start + tRow, 1);
            }
        }

        void updateValue(SubsysDesc desc, String name, double value) {
            Integer tRow = desc.chanMap.get(name);
            if (tRow == null) {
                return;
            }
            this.setValueAt(value, desc.start + tRow, 1);
        }

        void updateLimitValue(SubsysDesc desc, MetadataStatus s) {
            Integer column;
            boolean high = s.getMetadataName().equals("alarmHigh");
            double limit = Double.valueOf(s.getMetadataValue());
            Integer tRow = desc.chanMap.get(s.getDataName());
            if (tRow == null) {
                return;
            }
            if (high) {
                desc.highLimits.set(desc.tsRowMap.get(tRow), limit);
                column = 4;
            } else {
                desc.lowLimits.set(desc.tsRowMap.get(tRow), limit);
                column = 3;
            }
            this.setValueAt(limit, desc.start + tRow, column);
        }

        void updateState(SubsysDesc desc, MonitorState s) {
            desc.goodChans = s.getGoodChans();
            desc.onlineChans = s.getOnlineChans();
            BitSet updateHigh = (BitSet)s.getHighLimitChange().clone();
            updateHigh.xor(desc.highLimitChange);
            desc.highLimitChange.xor(updateHigh);
            int sRow = updateHigh.nextSetBit(0);
            while (sRow >= 0) {
                this.setValueAt(desc.highLimits.get(sRow), desc.start + desc.stRowMap.get(sRow), 4);
                sRow = updateHigh.nextSetBit(sRow + 1);
            }
            BitSet updateLow = (BitSet)s.getLowLimitChange().clone();
            updateLow.xor(desc.lowLimitChange);
            desc.lowLimitChange.xor(updateLow);
            int sRow2 = updateLow.nextSetBit(0);
            while (sRow2 >= 0) {
                this.setValueAt(desc.lowLimits.get(sRow2), desc.start + desc.stRowMap.get(sRow2), 3);
                sRow2 = updateLow.nextSetBit(sRow2 + 1);
            }
        }
    }

    class TrendingValue {
        TrendingValue() {
        }
    }

    class UpdateLimitValue
    implements Runnable {
        SubsysDesc desc;
        MetadataStatus s;

        UpdateLimitValue(SubsysDesc desc, MetadataStatus s) {
            this.desc = desc;
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel()).updateLimitValue(this.desc, this.s);
        }
    }

    class UpdateState
    implements Runnable {
        SubsysDesc desc;
        MonitorState s;

        UpdateState(SubsysDesc desc, MonitorState s) {
            this.desc = desc;
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel()).updateState(this.desc, this.s);
        }
    }

    class UpdateTableValue
    implements Runnable {
        SubsysDesc desc;
        String n;
        double v;

        UpdateTableValue(SubsysDesc desc, String n, double v) {
            this.desc = desc;
            this.n = n;
            this.v = v;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel()).updateValue(this.desc, this.n, this.v);
        }
    }

    class UpdateTrendingTable
    implements Runnable {
        SubsysDesc desc;
        TrendingStatus s;

        UpdateTrendingTable(SubsysDesc desc, TrendingStatus s) {
            this.desc = desc;
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel()).updateValues(this.desc, this.s);
        }
    }

    class UpdateTrendingTableModel
    implements Runnable {
        SubsysDesc desc;
        MonitorFullState s;

        UpdateTrendingTableModel(SubsysDesc desc, MonitorFullState s) {
            this.desc = desc;
            this.s = s;
        }

        @Override
        public void run() {
            this.desc.indent = false;
            this.desc.chanMap.clear();
            this.desc.tsRowMap.clear();
            this.desc.stRowMap.clear();
            this.desc.goodChans.clear();
            this.desc.onlineChans.clear();
            this.desc.lowLimitChange.clear();
            this.desc.highLimitChange.clear();
            this.desc.lowLimits.clear();
            this.desc.highLimits.clear();
            TrendingTableModel model = (TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel();
            int j = 0;
            while (j < this.desc.size) {
                model.removeRow(this.desc.start);
                ++j;
            }
            this.desc.end = this.desc.start;
            List channels = this.s.getChannels();
            for (MonitorChan chan : channels) {
                model.addTrendingRow(this.desc, chan);
            }
            this.desc.size = this.desc.end - this.desc.start;
            int row = 0;
            for (SubsysDesc d : MonitorTrendingTable.this.subsysMap.values()) {
                d.start = row;
                d.end = row += d.size;
            }
            int c = 0;
            while (c < MonitorTrendingTable.this.jTable1.getColumnCount()) {
                TableColumnModel colModel = MonitorTrendingTable.this.jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr = MonitorTrendingTable.this.jTable1.getTableHeader().getDefaultRenderer();
                Component comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.jTable1, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                rndr = MonitorTrendingTable.this.jTable1.getCellRenderer(0, c);
                Class<?> colClass = MonitorTrendingTable.this.jTable1.getColumnClass(c);
                if (!colClass.equals(String.class)) {
                    comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.jTable1, -999.99, false, false, 0, c);
                    width = Math.max(width, comp.getPreferredSize().width);
                } else {
                    int r = this.desc.start;
                    while (r < this.desc.end) {
                        Object value = MonitorTrendingTable.this.jTable1.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.jTable1, value, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                        ++r;
                    }
                }
                col.setPreferredWidth(width + 4);
                ++c;
            }
            model.updateState(this.desc, this.s.getMonitorState());
        }
    }
}

