package org.lsst.ccs.subsystem.common.devices.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

import org.lsst.ccs.utilities.logging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 ***************************************************************************
 **
 ** Contains the state of the Devices
 ** @author Homer Neal *
 * **************************************************************************
 */
public class DevicesConfig implements Serializable {

    public enum operating_states {

        IDLE, READY, TEST, ACQ1, WARM, ACQ3, ACQ4, ACQ5, EXPERT;
    }
    public static final String[] COMPONENT_NAMES = {"IDLE", "READY", "TEST", "ACQ1", "WARM"};

    public enum EVENT_ID {

        BIAS,
        CRYO,
        VAC,
        PD,
        LMP;
    }
    
    public enum CryoTelType {
        CRYO,
        COLD1,
        COLD2;
    }

    public static int MAXSTATES = operating_states.values().length;
    private int cfgstate = 0;

    private double[] biasVAcq = new double[MAXSTATES];           // Bias volts during acquisition
    private double[] cryoTAcq = new double[MAXSTATES];           // cryo temp during acquisition
    private double[] vacPAcq = new double[MAXSTATES];            // pressure during acquisition
    private double[] lambdaAcq = new double[MAXSTATES];          // wavelength during acquisition
    private String[] filter_names;                 // names of the filters
    private double[] filter_edges = new double[6]; // wl edge at which filter should be selected
    private String srctype;              // lamp source type
    private String monotype;             // monochromator type
    private String pdtype;               // photodiode type
    private String biastype;             // bias dev type
    private int pdcnt = 0;              // # readings
    private double pdnplc = 1.0;           // nplc (measurement rate)
    private int biason;               // is the bias output on
    private double[] minLmpPwr = new double[MAXSTATES];         // min. lamp power for acquisition
    private double[] cryoTAcqTol = new double[MAXSTATES];        // tolerance on the CCD temp
    private String configFile;

    public DevicesConfig() {
//        this.configFile = System.getProperty("lsst.ccs.comcam.configFile", "Devices.cfg");
//        System.out.println("Config file path is: " + configFile);
    }

    public DevicesConfig(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        update(biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        update(cfgstate, biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(int istate, double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.biasVAcq[istate] = biasVAcq;
        this.cryoTAcq[istate] = cryoTAcq;
        this.cryoTAcqTol[istate] = cryoTAcqTol;
        this.vacPAcq[istate] = vacPAcq;
        this.lambdaAcq[istate] = lambdaAcq;
        this.minLmpPwr[istate] = minLmpPwr;

    }

    public double getBiasVAcq() {
        return biasVAcq[cfgstate];
    }

    public double getCryoTAcq() {
        return cryoTAcq[cfgstate];
    }

    public void setCryoTAcq(double cryoTAcq, int istate) {
        this.cryoTAcq[istate] = cryoTAcq;
    }

    public double getVacPAcq() {
        return vacPAcq[cfgstate];
    }

    public double getLambdaAcq() {
        return lambdaAcq[cfgstate];
    }

    public String[] getFilters() {
        return filter_names;
    }

    public String getSrcType() {
        return srctype;
    }

    public String getMonoType() {
        return monotype;
    }

    public String getPDType() {
        return pdtype;
    }

    public String getBIASType() {
        return biastype;
    }

    public int getPDcnt() {
        return pdcnt;
    }

    public void setPDcnt(int pdcnt) {
        this.pdcnt = pdcnt;
    }

    public double getPDnplc() {
        return pdnplc;
    }

    public void setPDnplc(double pdnplc) {
        this.pdnplc = pdnplc;
    }

    public int getBiason() {
        return biason;
    }

    public void setBiason(int biason) {
        this.biason = biason;
    }

    public double getMinLmpPwr() {
        return minLmpPwr[cfgstate];
    }

    public void setCryoTAcqTol(double cryoTAcqTol) {
        this.cryoTAcqTol[cfgstate] = cryoTAcqTol;
    }

    public double getCryoTAcqTol() {
        return cryoTAcqTol[cfgstate];
    }

    public void setCfgState(int cfgstate) {
        this.cfgstate = cfgstate;
    }

    public int getCfgstate() {
        return cfgstate;
    }

    public double[] getFilter_edges() {
        return filter_edges;
    }

    public void setFilter_edges(double[] filter_edges) {
        this.filter_edges = filter_edges;
    }

    public void setBiasVAcq(double biasVAcq) {
        this.biasVAcq[cfgstate] = biasVAcq;
    }

    public void setBiasVAcq(double biasVAcq, int istate) {
        this.biasVAcq[istate] = biasVAcq;
    }

    public void setCryoTAcq(double cryoTAcq) {
        this.cryoTAcq[cfgstate] = cryoTAcq;
    }

    public void setVacPAcq(double vacPAcq) {
        this.vacPAcq[cfgstate] = vacPAcq;
    }

    public void setLambdaAcq(double lambdaAcq) {
        this.lambdaAcq[cfgstate] = lambdaAcq;
    }

    public void setFilter_names(String[] filter_names) {
        this.filter_names = filter_names;
    }

    public void setSrctype(String srctype) {
        this.srctype = srctype;
    }

    public void setMonotype(String monotype) {
        this.monotype = monotype;
    }

    public void setPdtype(String pdtype) {
        this.pdtype = pdtype;
    }

    public void setBiastype(String biastype) {
        this.biastype = biastype;
    }

    public void setMinLmpPwr(double minLmpPwr) {
        this.minLmpPwr[cfgstate] = minLmpPwr;
    }


    @Override
    public String toString() {
        String line = "";
        for (operating_states stat : operating_states.values()) {
            int icfg = stat.ordinal();
            line
                    += "state=" + stat.name()
                    + ", biasVAcq=" + biasVAcq[icfg]
                    + ", cryoTAcq=" + cryoTAcq[icfg]
                    + ", vacPAcq=" + vacPAcq[icfg]
                    + ", lambdaAcq=" + lambdaAcq[icfg];
        }
        line += ", filter_names=" + filter_names
                + ", srctype=" + srctype
                + ", monotype=" + monotype
                + ", pdtype=" + pdtype
                + ", biastype=" + biastype;
//                + ", possible states are IDLE = " + operating_states.values();
        return line;
    }
    
}
