package org.lsst.ccs.subsystem.common.actions;

import java.io.Serializable;
import org.lsst.ccs.bus.data.Alert;

/**
 *  Manages the MPM alert action payload
 * 
 *  @author saxton
 */
public class MpmAction implements Serializable {

    public enum Action { BLOCK_UT_POWER, BLOCK_REFRIG }

    Action action;   // The action to perform


    /**
     *  Constructor.
     * 
     *  @param action  The action to perform
     */
    public MpmAction(Action action)
    {
        this.action = action;
    }


    /**
     *  Gets the simple name of this class.
     * 
     *  @return  The name
     */
    public static String getName()
    {
        return MpmAction.class.getSimpleName();
    }


    /**
     *  Gets the name of the client property.
     * 
     *  @return  The name
     */
    public static String getClientName()
    {
        return getName() + "Client";
    }


    /**
     *  Gets the name of the manager property.
     * 
     *  @return  The name
     */
    public static String getManagerName()
    {
        return getName() + "Manager";
    }


    /**
     *  Adds data to an alert
     * 
     *  @param  alert  The alert
     *  @param  action  The action to perform
     */
    public static void addData(Alert alert, Action action)
    {
        alert.addAlertData(getName(), new MpmAction(action));
    }


    /**
     *  Gets data from an alert.
     * 
     *  @param  alert  The alert
     *  @return  The action, or null if the alert doesn't contain MPM data
     */
    public static Action getData(Alert alert)
    {
        Object data = alert.getAlertData(getName());
        return data instanceof MpmAction ? ((MpmAction)data).action : null;
    }

    private static final long serialVersionUID = 6862433443745351322L;
}
