package org.lsst.ccs.subsystem.common.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *  Contains the basic state of a subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class BasicState implements Serializable {
    
    public static final String KEY = "BasicState";

    private final int tickMillis;         // Monitoring publishing period (ms)
 
    public BasicState(int tickMillis)
    {
        this.tickMillis = tickMillis;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    private static final long serialVersionUID = -58762426004996474L;
}
