package org.lsst.ccs.subsystem.common.devices.refrigeration.states;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 ** Contains the state of the Cryo device
 ** @author Homer Neal *
 * **************************************************************************
 */
public class CryoDevState implements Serializable {

    private static final long serialVersionUID = -7596686997197536530L;

    public static final String KEY = "TSState";

    static int ibit = 19;
    static int LEDDEVC_ON_BIT,ACCUM_DONE_BIT,FE55_ON_BIT,CRYO_DEV_WARNING_BIT,VAC_DEV_WARNING_BIT;

    int systemState;           // Mask of state bits
    int operState;             // ordinal operating state (READY,IDLE,ACQ1,...)
    int tickMillis;            // Data status update period (ms)
    double temp;               // cryo temp
    double temp2;               // cryo temp

    String warning;            // any current warning string

    public enum onOff {

        OFF, ON;
    }

    public enum cryostates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED;
    }


    public int getTickMillis() {
        return tickMillis;
    }

    public double getTemp() {
        return temp;
    }

    public void setTemp(double temp) {
        this.temp = temp;
    }

    public double getTemp2() {
        return temp2;
    }

    public void setTemp2(double temp2) {
        this.temp2 = temp2;
    }


    @Override
    public String toString() {
        return "tickMillis=" + tickMillis
                + ", cryo temp=" + temp
                + ", cryo temp2=" + temp2;
    }

}
