package org.lsst.ccs.subsystem.common.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for TwisTorr Turbo Pump
 *
 *  @author Al Eisner
 */
public enum TurboAlerts {

    IN_AUTOTUNING  ("In_Autotuning", "Turbo Pump is in autotuning state");

    private final String id, description;
    
    TurboAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public String getAlertId(String name) {
        return getId()+"/"+name;
    }

    public Alert newAlert(String name) {
        return new Alert(getAlertId(name), getDescription());
    }

}
