/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.focalplane;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.subsystem.common.focalplane.FocalPlaneDataGroup;

public class FocalPlaneDataGroupTest {
    @Test
    public void matchingTests() {
        DataProviderInfo dpi0 = new DataProviderInfo("R10/Reb0/Temp0", DataProviderInfo.Type.MONITORING, "Temp0");
        FocalPlaneDataGroup g = FocalPlaneDataGroup.findFocalPlanDataGroup((DataProviderInfo)dpi0);
        g.addAttributesToDataInfo(dpi0);
        Assert.assertEquals((Object)FocalPlaneDataGroup.REB_TEMPERATURE, (Object)g);
        Assert.assertEquals((Object)"R10", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.RAFT_ID));
        Assert.assertEquals((Object)"Reb0", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.REB_ID));
        dpi0 = new DataProviderInfo("R00/WReb/Temp0", DataProviderInfo.Type.MONITORING, "Temp0");
        g = FocalPlaneDataGroup.findFocalPlanDataGroup((DataProviderInfo)dpi0);
        g.addAttributesToDataInfo(dpi0);
        Assert.assertEquals((Object)FocalPlaneDataGroup.REB_TEMPERATURE, (Object)g);
        Assert.assertEquals((Object)"R00", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.RAFT_ID));
        Assert.assertEquals((Object)"WReb", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.REB_ID));
        dpi0 = new DataProviderInfo("R32/Reb1/digital/IaftLDO", DataProviderInfo.Type.MONITORING, "IaftLDO");
        g = FocalPlaneDataGroup.findFocalPlanDataGroup((DataProviderInfo)dpi0);
        g.addAttributesToDataInfo(dpi0);
        Assert.assertEquals((Object)FocalPlaneDataGroup.PS_REB_DIGITAL_CURRENT, (Object)g);
        Assert.assertEquals((Object)"R32", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.RAFT_ID));
        Assert.assertEquals((Object)"Reb1", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.REB_ID));
        dpi0 = new DataProviderInfo("R41/Reb2/analog/VaftLDO", DataProviderInfo.Type.MONITORING, "VaftLDO");
        g = FocalPlaneDataGroup.findFocalPlanDataGroup((DataProviderInfo)dpi0);
        g.addAttributesToDataInfo(dpi0);
        Assert.assertEquals((Object)FocalPlaneDataGroup.PS_REB_ANALOG_VOLTAGE, (Object)g);
        Assert.assertEquals((Object)"R41", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.RAFT_ID));
        Assert.assertEquals((Object)"Reb2", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.REB_ID));
        dpi0 = new DataProviderInfo("R40/GReb/dphi/VaftSwch", DataProviderInfo.Type.MONITORING, "VaftSwch");
        g = FocalPlaneDataGroup.findFocalPlanDataGroup((DataProviderInfo)dpi0);
        g.addAttributesToDataInfo(dpi0);
        Assert.assertEquals((Object)FocalPlaneDataGroup.PS_REB_DPHI_VOLTAGE, (Object)g);
        Assert.assertEquals((Object)"R40", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.RAFT_ID));
        Assert.assertEquals((Object)"GReb", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.REB_ID));
        dpi0 = new DataProviderInfo("R33/Reb2/Power", DataProviderInfo.Type.MONITORING, "Power");
        g = FocalPlaneDataGroup.findFocalPlanDataGroup((DataProviderInfo)dpi0);
        g.addAttributesToDataInfo(dpi0);
        Assert.assertEquals((Object)FocalPlaneDataGroup.BOARD_POWER, (Object)g);
        Assert.assertEquals((Object)"R33", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.RAFT_ID));
        Assert.assertEquals((Object)"Reb2", (Object)dpi0.getAttributeValue(DataProviderInfo.Attribute.REB_ID));
    }
}

