package org.lsst.ccs.subsystem.common.devices.refrigeration.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

//import org.lsst.ccs.bus.data.ConfigurationInfo;
//import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

import org.lsst.ccs.utilities.logging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
//import org.lsst.ccs.bus.messages.StatusMessage;

/**
 ***************************************************************************
 **
 ** Contains the data about the Refrigeration device 
 ** @author Homer Neal *
 * **************************************************************************
 */
public class RefrigerationConfig implements Serializable {

    public enum operating_states {

        IDLE, READY, TEST, ACQ1, WARM, ACQ3, ACQ4, ACQ5, EXPERT;
    }
    public static final String[] COMPONENT_NAMES = {"IDLE", "READY", "TEST", "ACQ1", "WARM"};

    public enum EVENT_ID {

        BIAS,
        CRYO,
        VAC,
        PD,
        LMP;
    }
    
    public enum CryoTelType {
        CRYO,
        COLD1,
        COLD2;
    }

    public static int MAXSTATES = operating_states.values().length;
    private int cfgstate = 0;
    private double[] cryoTAcq = new double[MAXSTATES];           // cryo temp during acquisition
    private double[] cryoTAcqTol = new double[MAXSTATES];        // tolerance on the CCD temp

    public double getCryoTAcq() {
        return cryoTAcq[cfgstate];
    }

    public void setCryoTAcq(double cryoTAcq, int istate) {
        this.cryoTAcq[istate] = cryoTAcq;
    }


    @Override
    public String toString() {
        String line = "";
        for (operating_states stat : operating_states.values()) {
            int icfg = stat.ordinal();
            line = "cryoTAcq=" + cryoTAcq[icfg];
        }
        return line;
    }


}
